/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.graph.AbstractTypedGraph;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class DirectedSparseGraph<V, E>
extends AbstractTypedGraph<V, E>
implements DirectedGraph<V, E> {
    protected Map<V, Pair<Map<V, E>>> vertices = new HashMap<V, Pair<Map<V, E>>>();
    protected Map<E, Pair<V>> edges = new HashMap<E, Pair<V>>();

    public static final <V, E> Supplier<DirectedGraph<V, E>> getFactory() {
        return new Supplier<DirectedGraph<V, E>>(){

            public DirectedGraph<V, E> get() {
                return new DirectedSparseGraph();
            }
        };
    }

    public DirectedSparseGraph() {
        super(EdgeType.DIRECTED);
    }

    @Override
    public boolean addEdge(E edge, Pair<? extends V> endpoints, EdgeType edgeType) {
        Object dest;
        this.validateEdgeType(edgeType);
        Pair<? extends V> new_endpoints = this.getValidatedEndpoints(edge, endpoints);
        if (new_endpoints == null) {
            return false;
        }
        Object source = new_endpoints.getFirst();
        if (this.findEdge(source, dest = new_endpoints.getSecond()) != null) {
            return false;
        }
        this.edges.put(edge, new_endpoints);
        if (!this.vertices.containsKey(source)) {
            this.addVertex(source);
        }
        if (!this.vertices.containsKey(dest)) {
            this.addVertex(dest);
        }
        ((Map)this.vertices.get(source).getSecond()).put(dest, edge);
        ((Map)this.vertices.get(dest).getFirst()).put(source, edge);
        return true;
    }

    @Override
    public E findEdge(V v1, V v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            return null;
        }
        return (E)((Map)this.vertices.get(v1).getSecond()).get(v2);
    }

    @Override
    public Collection<E> findEdgeSet(V v1, V v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            return null;
        }
        ArrayList<E> edge_collection = new ArrayList<E>(1);
        E e = this.findEdge(v1, v2);
        if (e == null) {
            return edge_collection;
        }
        edge_collection.add(e);
        return edge_collection;
    }

    protected Collection<E> getIncoming_internal(V vertex) {
        return ((Map)this.vertices.get(vertex).getFirst()).values();
    }

    protected Collection<E> getOutgoing_internal(V vertex) {
        return ((Map)this.vertices.get(vertex).getSecond()).values();
    }

    protected Collection<V> getPreds_internal(V vertex) {
        return ((Map)this.vertices.get(vertex).getFirst()).keySet();
    }

    protected Collection<V> getSuccs_internal(V vertex) {
        return ((Map)this.vertices.get(vertex).getSecond()).keySet();
    }

    public Collection<E> getInEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        return Collections.unmodifiableCollection(this.getIncoming_internal(vertex));
    }

    public Collection<E> getOutEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        return Collections.unmodifiableCollection(this.getOutgoing_internal(vertex));
    }

    public Collection<V> getPredecessors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        return Collections.unmodifiableCollection(this.getPreds_internal(vertex));
    }

    public Collection<V> getSuccessors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        return Collections.unmodifiableCollection(this.getSuccs_internal(vertex));
    }

    public Pair<V> getEndpoints(E edge) {
        if (!this.containsEdge(edge)) {
            return null;
        }
        return this.edges.get(edge);
    }

    public V getSource(E directed_edge) {
        if (!this.containsEdge(directed_edge)) {
            return null;
        }
        return (V)this.edges.get(directed_edge).getFirst();
    }

    public V getDest(E directed_edge) {
        if (!this.containsEdge(directed_edge)) {
            return null;
        }
        return (V)this.edges.get(directed_edge).getSecond();
    }

    public boolean isSource(V vertex, E edge) {
        if (!this.containsEdge(edge) || !this.containsVertex(vertex)) {
            return false;
        }
        return vertex.equals(this.getEndpoints(edge).getFirst());
    }

    public boolean isDest(V vertex, E edge) {
        if (!this.containsEdge(edge) || !this.containsVertex(vertex)) {
            return false;
        }
        return vertex.equals(this.getEndpoints(edge).getSecond());
    }

    public Collection<E> getEdges() {
        return Collections.unmodifiableCollection(this.edges.keySet());
    }

    public Collection<V> getVertices() {
        return Collections.unmodifiableCollection(this.vertices.keySet());
    }

    public boolean containsVertex(V vertex) {
        return this.vertices.containsKey(vertex);
    }

    public boolean containsEdge(E edge) {
        return this.edges.containsKey(edge);
    }

    public int getEdgeCount() {
        return this.edges.size();
    }

    public int getVertexCount() {
        return this.vertices.size();
    }

    public Collection<V> getNeighbors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<V> neighbors = new HashSet<V>();
        neighbors.addAll(this.getPreds_internal(vertex));
        neighbors.addAll(this.getSuccs_internal(vertex));
        return Collections.unmodifiableCollection(neighbors);
    }

    public Collection<E> getIncidentEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<E> incident_edges = new HashSet<E>();
        incident_edges.addAll(this.getIncoming_internal(vertex));
        incident_edges.addAll(this.getOutgoing_internal(vertex));
        return Collections.unmodifiableCollection(incident_edges);
    }

    public boolean addVertex(V vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("vertex may not be null");
        }
        if (!this.containsVertex(vertex)) {
            this.vertices.put((Pair)vertex, (Pair<Map<Pair, E>>)new Pair(new HashMap(), new HashMap()));
            return true;
        }
        return false;
    }

    public boolean removeVertex(V vertex) {
        if (!this.containsVertex(vertex)) {
            return false;
        }
        ArrayList<E> incident = new ArrayList<E>(this.getIncoming_internal(vertex));
        incident.addAll(this.getOutgoing_internal(vertex));
        for (E edge : incident) {
            this.removeEdge(edge);
        }
        this.vertices.remove(vertex);
        return true;
    }

    public boolean removeEdge(E edge) {
        if (!this.containsEdge(edge)) {
            return false;
        }
        Pair<V> endpoints = this.getEndpoints(edge);
        Object source = endpoints.getFirst();
        Object dest = endpoints.getSecond();
        ((Map)this.vertices.get(source).getSecond()).remove(dest);
        ((Map)this.vertices.get(dest).getFirst()).remove(source);
        this.edges.remove(edge);
        return true;
    }
}

