/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import com.google.common.base.Function;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;

public class PajekNetWriter<V, E> {
    public void save(Graph<V, E> g, String filename, Function<V, String> vs, Function<E, Number> nev, Function<V, Point2D> vld) throws IOException {
        this.save(g, new FileWriter(filename), vs, nev, vld);
    }

    public void save(Graph<V, E> g, String filename, Function<V, String> vs, Function<E, Number> nev) throws IOException {
        this.save(g, new FileWriter(filename), vs, nev, null);
    }

    public void save(Graph<V, E> g, String filename) throws IOException {
        this.save(g, filename, null, null, null);
    }

    public void save(Graph<V, E> g, Writer w) throws IOException {
        this.save(g, w, null, null, null);
    }

    public void save(Graph<V, E> g, Writer w, Function<V, String> vs, Function<E, Number> nev) throws IOException {
        this.save(g, w, vs, nev, null);
    }

    public void save(Graph<V, E> graph, Writer w, Function<V, String> vs, Function<E, Number> nev, Function<V, Point2D> vld) throws IOException {
        BufferedWriter writer = new BufferedWriter(w);
        if (nev == null) {
            nev = new Function<E, Number>(){

                public Number apply(E e) {
                    return 1;
                }
            };
        }
        writer.write("*Vertices " + graph.getVertexCount());
        writer.newLine();
        ArrayList id = new ArrayList(graph.getVertices());
        for (Object currentVertex : graph.getVertices()) {
            Point2D location;
            String label;
            int v_id = id.indexOf(currentVertex) + 1;
            writer.write("" + v_id);
            if (vs != null && (label = (String)vs.apply(currentVertex)) != null) {
                writer.write(" \"" + label + "\"");
            }
            if (vld != null && (location = (Point2D)vld.apply(currentVertex)) != null) {
                writer.write(" " + location.getX() + " " + location.getY() + " 0.0");
            }
            writer.newLine();
        }
        HashSet d_set = new HashSet();
        HashSet u_set = new HashSet();
        boolean directed = graph instanceof DirectedGraph;
        boolean undirected = graph instanceof UndirectedGraph;
        if (directed) {
            d_set.addAll(graph.getEdges());
        }
        if (undirected) {
            u_set.addAll(graph.getEdges());
        }
        if (!directed && !undirected) {
            u_set.addAll(graph.getEdges());
            d_set.addAll(graph.getEdges());
            for (Object e : graph.getEdges()) {
                if (graph.getEdgeType(e) == EdgeType.UNDIRECTED) {
                    d_set.remove(e);
                    continue;
                }
                u_set.remove(e);
            }
        }
        if (!d_set.isEmpty()) {
            writer.write("*Arcs");
            writer.newLine();
        }
        for (Object e : d_set) {
            int source_id = id.indexOf(graph.getEndpoints(e).getFirst()) + 1;
            int target_id = id.indexOf(graph.getEndpoints(e).getSecond()) + 1;
            float weight = ((Number)nev.apply(e)).floatValue();
            writer.write(source_id + " " + target_id + " " + weight);
            writer.newLine();
        }
        if (!u_set.isEmpty()) {
            writer.write("*Edges");
            writer.newLine();
        }
        for (Object e : u_set) {
            Pair endpoints = graph.getEndpoints(e);
            int v1_id = id.indexOf(endpoints.getFirst()) + 1;
            int v2_id = id.indexOf(endpoints.getSecond()) + 1;
            float weight = ((Number)nev.apply(e)).floatValue();
            writer.write(v1_id + " " + v2_id + " " + weight);
            writer.newLine();
        }
        writer.close();
    }
}

