/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import edu.uci.ics.jung.algorithms.layout.AbstractLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout2;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout;
import edu.uci.ics.jung.algorithms.layout.util.Relaxer;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.ObservableGraph;
import edu.uci.ics.jung.graph.event.GraphEvent;
import edu.uci.ics.jung.graph.event.GraphEventListener;
import edu.uci.ics.jung.graph.util.Graphs;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JRootPane;

public class AddNodeDemo
extends JApplet {
    private static final long serialVersionUID = -5345319851341875800L;
    private Graph<Number, Number> g = null;
    private VisualizationViewer<Number, Number> vv = null;
    private AbstractLayout<Number, Number> layout = null;
    Timer timer;
    boolean done;
    protected JButton switchLayout;
    public static final int EDGE_LENGTH = 100;
    Integer v_prev = null;

    @Override
    public void init() {
        DirectedGraph ig = Graphs.synchronizedDirectedGraph((DirectedGraph)new DirectedSparseMultigraph());
        ObservableGraph og = new ObservableGraph((Graph)ig);
        og.addGraphEventListener((GraphEventListener)new GraphEventListener<Number, Number>(){

            public void handleGraphEvent(GraphEvent<Number, Number> evt) {
                System.err.println("got " + evt);
            }
        });
        this.g = og;
        this.layout = new FRLayout2(this.g);
        this.vv = new VisualizationViewer(this.layout, new Dimension(600, 600));
        JRootPane rp = this.getRootPane();
        rp.putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBackground(Color.lightGray);
        this.getContentPane().setFont(new Font("Serif", 0, 12));
        this.vv.getModel().getRelaxer().setSleepTime(500L);
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)new DefaultModalGraphMouse());
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        this.vv.getRenderContext().setVertexLabelTransformer((Function)new ToStringLabeller());
        this.vv.setForeground(Color.white);
        this.getContentPane().add((Component)this.vv);
        this.switchLayout = new JButton("Switch to SpringLayout");
        this.switchLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Dimension d = new Dimension(600, 600);
                if (AddNodeDemo.this.switchLayout.getText().indexOf("Spring") > 0) {
                    AddNodeDemo.this.switchLayout.setText("Switch to FRLayout");
                    AddNodeDemo.this.layout = (AbstractLayout)new SpringLayout(AddNodeDemo.this.g, Functions.constant((Object)100));
                    AddNodeDemo.this.layout.setSize(d);
                    AddNodeDemo.this.vv.getModel().setGraphLayout((Layout)AddNodeDemo.this.layout, d);
                } else {
                    AddNodeDemo.this.switchLayout.setText("Switch to SpringLayout");
                    AddNodeDemo.this.layout = (AbstractLayout)new FRLayout(AddNodeDemo.this.g, d);
                    AddNodeDemo.this.vv.getModel().setGraphLayout((Layout)AddNodeDemo.this.layout, d);
                }
            }
        });
        this.getContentPane().add((Component)this.switchLayout, "South");
        this.timer = new Timer();
    }

    @Override
    public void start() {
        this.validate();
        this.timer.schedule((TimerTask)new RemindTask(), 1000L, 1000L);
        this.vv.repaint();
    }

    public void process() {
        try {
            if (this.g.getVertexCount() < 100) {
                this.layout.lock(true);
                Integer v1 = new Integer(this.g.getVertexCount());
                Relaxer relaxer = this.vv.getModel().getRelaxer();
                relaxer.pause();
                this.g.addVertex((Object)v1);
                System.err.println("added node " + v1);
                if (this.v_prev != null) {
                    this.g.addEdge((Object)this.g.getEdgeCount(), (Object)this.v_prev, (Object)v1);
                    int rand = (int)(Math.random() * (double)this.g.getVertexCount());
                    this.g.addEdge((Object)this.g.getEdgeCount(), (Object)v1, (Object)rand);
                }
                this.v_prev = v1;
                this.layout.initialize();
                relaxer.resume();
                this.layout.lock(false);
            } else {
                this.done = true;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void main(String[] args) {
        AddNodeDemo and = new AddNodeDemo();
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(and);
        and.init();
        and.start();
        frame.pack();
        frame.setVisible(true);
    }

    class RemindTask
    extends TimerTask {
        RemindTask() {
        }

        @Override
        public void run() {
            AddNodeDemo.this.process();
            if (AddNodeDemo.this.done) {
                this.cancel();
            }
        }
    }
}

