/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import edu.uci.ics.jung.visualization.renderers.DefaultEdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.DefaultVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.EdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.VertexLabelRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DrawnIconVertexDemo {
    Graph<Integer, Number> graph = new DirectedSparseGraph();
    VisualizationViewer<Integer, Number> vv;

    public DrawnIconVertexDemo() {
        Integer[] v = this.createVertices(10);
        this.createEdges(v);
        this.vv = new VisualizationViewer((Layout)new FRLayout(this.graph));
        this.vv.getRenderContext().setVertexLabelTransformer((Function)new Function<Integer, String>(){

            public String apply(Integer v) {
                return "Vertex " + v;
            }
        });
        this.vv.getRenderContext().setVertexLabelRenderer((VertexLabelRenderer)new DefaultVertexLabelRenderer(Color.cyan));
        this.vv.getRenderContext().setEdgeLabelRenderer((EdgeLabelRenderer)new DefaultEdgeLabelRenderer(Color.cyan));
        this.vv.getRenderContext().setVertexIconTransformer((Function)new Function<Integer, Icon>(){

            public Icon apply(final Integer v) {
                return new Icon(){

                    @Override
                    public int getIconHeight() {
                        return 20;
                    }

                    @Override
                    public int getIconWidth() {
                        return 20;
                    }

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        if (DrawnIconVertexDemo.this.vv.getPickedVertexState().isPicked((Object)v)) {
                            g.setColor(Color.yellow);
                        } else {
                            g.setColor(Color.red);
                        }
                        g.fillOval(x, y, 20, 20);
                        if (DrawnIconVertexDemo.this.vv.getPickedVertexState().isPicked((Object)v)) {
                            g.setColor(Color.black);
                        } else {
                            g.setColor(Color.white);
                        }
                        g.drawString("" + v, x + 6, y + 15);
                    }
                };
            }
        });
        this.vv.getRenderContext().setVertexFillPaintTransformer((Function)new PickableVertexPaintTransformer((PickedInfo)this.vv.getPickedVertexState(), (Paint)Color.white, (Paint)Color.yellow));
        this.vv.getRenderContext().setEdgeDrawPaintTransformer((Function)new PickableEdgePaintTransformer((PickedInfo)this.vv.getPickedEdgeState(), (Paint)Color.black, (Paint)Color.lightGray));
        this.vv.setBackground(Color.white);
        this.vv.setVertexToolTipTransformer((Function)new ToStringLabeller());
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add((Component)panel);
        frame.setDefaultCloseOperation(3);
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)gm);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(DrawnIconVertexDemo.this.vv, 1.1f, DrawnIconVertexDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(DrawnIconVertexDemo.this.vv, 0.9090909f, DrawnIconVertexDemo.this.vv.getCenter());
            }
        });
        JPanel controls = new JPanel();
        controls.add(plus);
        controls.add(minus);
        controls.add(gm.getModeComboBox());
        content.add((Component)controls, "South");
        frame.pack();
        frame.setVisible(true);
    }

    private Integer[] createVertices(int count) {
        Integer[] v = new Integer[count];
        for (int i = 0; i < count; ++i) {
            v[i] = new Integer(i);
            this.graph.addVertex((Object)v[i]);
        }
        return v;
    }

    void createEdges(Integer[] v) {
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[0], (Object)v[1], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[0], (Object)v[3], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[0], (Object)v[4], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[4], (Object)v[5], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[3], (Object)v[5], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[1], (Object)v[2], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[1], (Object)v[4], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[8], (Object)v[2], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[3], (Object)v[8], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[6], (Object)v[7], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[7], (Object)v[5], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[0], (Object)v[9], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[9], (Object)v[8], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[7], (Object)v[6], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[6], (Object)v[5], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[4], (Object)v[2], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[5], (Object)v[4], EdgeType.DIRECTED);
    }

    public static void main(String[] args) {
        new DrawnIconVertexDemo();
    }
}

