/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.generators.random.MixedRandomGraphGenerator;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.scoring.VertexScorer;
import edu.uci.ics.jung.algorithms.scoring.VoltageScorer;
import edu.uci.ics.jung.algorithms.scoring.util.VertexScoreTransformer;
import edu.uci.ics.jung.algorithms.util.SelfLoopEdgePredicate;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractPopupGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.AbstractVertexShapeTransformer;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.GradientEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.NumberFormattingTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeArrowRenderingSupport;
import edu.uci.ics.jung.visualization.renderers.CachingEdgeRenderer;
import edu.uci.ics.jung.visualization.renderers.CachingVertexRenderer;
import edu.uci.ics.jung.visualization.renderers.CenterEdgeArrowRenderingSupport;
import edu.uci.ics.jung.visualization.renderers.EdgeArrowRenderingSupport;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;

public class PluggableRendererDemo
extends JApplet
implements ActionListener {
    protected JCheckBox v_color;
    protected JCheckBox e_color;
    protected JCheckBox v_stroke;
    protected JCheckBox e_uarrow_pred;
    protected JCheckBox e_darrow_pred;
    protected JCheckBox e_arrow_centered;
    protected JCheckBox v_shape;
    protected JCheckBox v_size;
    protected JCheckBox v_aspect;
    protected JCheckBox v_labels;
    protected JRadioButton e_line;
    protected JRadioButton e_bent;
    protected JRadioButton e_wedge;
    protected JRadioButton e_quad;
    protected JRadioButton e_ortho;
    protected JRadioButton e_cubic;
    protected JCheckBox e_labels;
    protected JCheckBox font;
    protected JCheckBox e_show_d;
    protected JCheckBox e_show_u;
    protected JCheckBox v_small;
    protected JCheckBox zoom_at_mouse;
    protected JCheckBox fill_edges;
    protected JRadioButton no_gradient;
    protected JRadioButton gradient_relative;
    protected static final int GRADIENT_NONE = 0;
    protected static final int GRADIENT_RELATIVE = 1;
    protected static int gradient_level = 0;
    protected SeedFillColor<Integer> seedFillColor;
    protected SeedDrawColor<Integer> seedDrawColor;
    protected EdgeWeightStrokeFunction<Number> ewcs;
    protected VertexStrokeHighlight<Integer, Number> vsh;
    protected Function<? super Integer, String> vs;
    protected Function<? super Integer, String> vs_none;
    protected Function<? super Number, String> es;
    protected Function<? super Number, String> es_none;
    protected VertexFontTransformer<Integer> vff;
    protected EdgeFontTransformer<Number> eff;
    protected VertexShapeSizeAspect<Integer, Number> vssa;
    protected DirectionDisplayPredicate<Integer, Number> show_edge;
    protected DirectionDisplayPredicate<Integer, Number> show_arrow;
    protected VertexDisplayPredicate<Integer, Number> show_vertex;
    protected Predicate<Context<Graph<Integer, Number>, Number>> self_loop;
    protected GradientPickedEdgePaintFunction<Integer, Number> edgeDrawPaint;
    protected GradientPickedEdgePaintFunction<Integer, Number> edgeFillPaint;
    protected static final Object VOLTAGE_KEY = "voltages";
    protected static final Object TRANSPARENCY = "transparency";
    protected Map<Number, Number> edge_weight = new HashMap<Number, Number>();
    protected Function<Integer, Double> voltages;
    protected Map<Integer, Number> transparency = new HashMap<Integer, Number>();
    protected VisualizationViewer<Integer, Number> vv;
    protected DefaultModalGraphMouse<Integer, Number> gm;
    protected Set<Integer> seedVertices = new HashSet<Integer>();
    private Graph<Integer, Number> graph;

    @Override
    public void start() {
        this.getContentPane().add(this.startFunction());
    }

    public static void main(String[] s) {
        JFrame jf = new JFrame();
        jf.setDefaultCloseOperation(3);
        JPanel jp = new PluggableRendererDemo().startFunction();
        jf.getContentPane().add(jp);
        jf.pack();
        jf.setVisible(true);
    }

    public JPanel startFunction() {
        this.graph = this.buildGraph();
        FRLayout layout = new FRLayout(this.graph);
        this.vv = new VisualizationViewer((Layout)layout);
        this.vv.getRenderer().setVertexRenderer((Renderer.Vertex)new CachingVertexRenderer(this.vv));
        this.vv.getRenderer().setEdgeRenderer((Renderer.Edge)new CachingEdgeRenderer(this.vv));
        PickedState picked_state = this.vv.getPickedVertexState();
        this.self_loop = new SelfLoopEdgePredicate();
        this.seedFillColor = new SeedFillColor(picked_state);
        this.seedDrawColor = new SeedDrawColor();
        this.ewcs = new EdgeWeightStrokeFunction<Number>(this.edge_weight);
        this.vsh = new VertexStrokeHighlight<Integer, Number>(this.graph, (PickedInfo<Integer>)picked_state);
        this.vff = new VertexFontTransformer();
        this.eff = new EdgeFontTransformer();
        this.vs_none = Functions.constant(null);
        this.es_none = Functions.constant(null);
        this.vssa = new VertexShapeSizeAspect<Integer, Number>(this.graph, this.voltages);
        this.show_edge = new DirectionDisplayPredicate(true, true);
        this.show_arrow = new DirectionDisplayPredicate(true, false);
        this.show_vertex = new VertexDisplayPredicate(false);
        this.edgeDrawPaint = new GradientPickedEdgePaintFunction<Integer, Number>((Function<Number, Paint>)new PickableEdgePaintTransformer((PickedInfo)this.vv.getPickedEdgeState(), (Paint)Color.black, (Paint)Color.cyan), this.vv);
        this.edgeFillPaint = new GradientPickedEdgePaintFunction<Integer, Number>((Function<Number, Paint>)new PickableEdgePaintTransformer((PickedInfo)this.vv.getPickedEdgeState(), (Paint)Color.black, (Paint)Color.cyan), this.vv);
        this.vv.getRenderContext().setVertexFillPaintTransformer(this.seedFillColor);
        this.vv.getRenderContext().setVertexDrawPaintTransformer(this.seedDrawColor);
        this.vv.getRenderContext().setVertexStrokeTransformer(this.vsh);
        this.vv.getRenderContext().setVertexLabelTransformer(this.vs_none);
        this.vv.getRenderContext().setVertexFontTransformer(this.vff);
        this.vv.getRenderContext().setVertexShapeTransformer(this.vssa);
        this.vv.getRenderContext().setVertexIncludePredicate(this.show_vertex);
        this.vv.getRenderContext().setEdgeDrawPaintTransformer(this.edgeDrawPaint);
        this.vv.getRenderContext().setEdgeLabelTransformer(this.es_none);
        this.vv.getRenderContext().setEdgeFontTransformer(this.eff);
        this.vv.getRenderContext().setEdgeStrokeTransformer(this.ewcs);
        this.vv.getRenderContext().setEdgeIncludePredicate(this.show_edge);
        this.vv.getRenderContext().setEdgeShapeTransformer((Function)EdgeShape.line(this.graph));
        this.vv.getRenderContext().setEdgeArrowPredicate(this.show_arrow);
        this.vv.getRenderContext().setArrowFillPaintTransformer(Functions.constant((Object)Color.lightGray));
        this.vv.getRenderContext().setArrowDrawPaintTransformer(Functions.constant((Object)Color.black));
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        this.vv.setBackground(Color.white);
        GraphZoomScrollPane scrollPane = new GraphZoomScrollPane(this.vv);
        jp.add((Component)scrollPane);
        this.gm = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(this.gm);
        this.gm.add((GraphMousePlugin)new PopupGraphMousePlugin());
        this.addBottomControls(jp);
        this.vssa.setScaling(true);
        this.vv.setVertexToolTipTransformer(new VoltageTips());
        this.vv.setToolTipText("<html><center>Use the mouse wheel to zoom<p>Click and Drag the mouse to pan<p>Shift-click and Drag to Rotate</center></html>");
        return jp;
    }

    public Graph<Integer, Number> buildGraph() {
        Supplier<Graph<Integer, Number>> graphFactory = new Supplier<Graph<Integer, Number>>(){

            public Graph<Integer, Number> get() {
                return new SparseMultigraph();
            }
        };
        Supplier<Integer> vertexFactory = new Supplier<Integer>(){
            int count;

            public Integer get() {
                return this.count++;
            }
        };
        Supplier<Number> edgeFactory = new Supplier<Number>(){
            int count;

            public Number get() {
                return this.count++;
            }
        };
        Graph g = MixedRandomGraphGenerator.generateMixedRandomGraph((Supplier)graphFactory, (Supplier)vertexFactory, (Supplier)edgeFactory, this.edge_weight, (int)20, this.seedVertices);
        this.es = new NumberFormattingTransformer(Functions.forMap(this.edge_weight));
        if (this.seedVertices.size() < 2) {
            System.out.println("need at least 2 seeds (one source, one sink)");
        }
        boolean source = true;
        HashSet<Integer> sources = new HashSet<Integer>();
        HashSet<Integer> sinks = new HashSet<Integer>();
        for (Integer v : this.seedVertices) {
            if (source) {
                sources.add(v);
            } else {
                sinks.add(v);
            }
            source = !source;
        }
        VoltageScorer voltage_scores = new VoltageScorer((Hypergraph)g, Functions.forMap(this.edge_weight), sources, sinks);
        voltage_scores.evaluate();
        this.voltages = new VertexScoreTransformer((VertexScorer)voltage_scores);
        this.vs = new NumberFormattingTransformer(this.voltages);
        Collection verts = g.getVertices();
        for (Integer v : verts) {
            this.transparency.put(v, new Double(0.9));
        }
        Integer v = (Integer)verts.iterator().next();
        Float e = new Float(Math.random());
        this.edge_weight.put(e, e);
        g.addEdge((Object)e, (Object)v, (Object)v);
        e = new Float(Math.random());
        this.edge_weight.put(e, e);
        g.addEdge((Object)e, (Object)v, (Object)v);
        return g;
    }

    protected void addBottomControls(JPanel jp) {
        JPanel control_panel = new JPanel();
        jp.add((Component)control_panel, "East");
        control_panel.setLayout(new BorderLayout());
        Box vertex_panel = Box.createVerticalBox();
        vertex_panel.setBorder(BorderFactory.createTitledBorder("Vertices"));
        Box edge_panel = Box.createVerticalBox();
        edge_panel.setBorder(BorderFactory.createTitledBorder("Edges"));
        Box both_panel = Box.createVerticalBox();
        control_panel.add((Component)vertex_panel, "North");
        control_panel.add((Component)edge_panel, "South");
        control_panel.add((Component)both_panel, "Center");
        this.v_color = new JCheckBox("seed highlight");
        this.v_color.addActionListener(this);
        this.v_stroke = new JCheckBox("stroke highlight on selection");
        this.v_stroke.addActionListener(this);
        this.v_labels = new JCheckBox("show voltage values");
        this.v_labels.addActionListener(this);
        this.v_shape = new JCheckBox("shape by degree");
        this.v_shape.addActionListener(this);
        this.v_size = new JCheckBox("size by voltage");
        this.v_size.addActionListener(this);
        this.v_size.setSelected(true);
        this.v_aspect = new JCheckBox("stretch by degree ratio");
        this.v_aspect.addActionListener(this);
        this.v_small = new JCheckBox("filter when degree < 4");
        this.v_small.addActionListener(this);
        vertex_panel.add(this.v_color);
        vertex_panel.add(this.v_stroke);
        vertex_panel.add(this.v_labels);
        vertex_panel.add(this.v_shape);
        vertex_panel.add(this.v_size);
        vertex_panel.add(this.v_aspect);
        vertex_panel.add(this.v_small);
        JPanel gradient_panel = new JPanel(new GridLayout(1, 0));
        gradient_panel.setBorder(BorderFactory.createTitledBorder("Edge paint"));
        this.no_gradient = new JRadioButton("Solid color");
        this.no_gradient.addActionListener(this);
        this.no_gradient.setSelected(true);
        this.gradient_relative = new JRadioButton("Gradient");
        this.gradient_relative.addActionListener(this);
        ButtonGroup bg_grad = new ButtonGroup();
        bg_grad.add(this.no_gradient);
        bg_grad.add(this.gradient_relative);
        gradient_panel.add(this.no_gradient);
        gradient_panel.add(this.gradient_relative);
        JPanel shape_panel = new JPanel(new GridLayout(3, 2));
        shape_panel.setBorder(BorderFactory.createTitledBorder("Edge shape"));
        this.e_line = new JRadioButton("line");
        this.e_line.addActionListener(this);
        this.e_line.setSelected(true);
        this.e_wedge = new JRadioButton("wedge");
        this.e_wedge.addActionListener(this);
        this.e_quad = new JRadioButton("quad curve");
        this.e_quad.addActionListener(this);
        this.e_cubic = new JRadioButton("cubic curve");
        this.e_cubic.addActionListener(this);
        this.e_ortho = new JRadioButton("orthogonal");
        this.e_ortho.addActionListener(this);
        ButtonGroup bg_shape = new ButtonGroup();
        bg_shape.add(this.e_line);
        bg_shape.add(this.e_wedge);
        bg_shape.add(this.e_quad);
        bg_shape.add(this.e_ortho);
        bg_shape.add(this.e_cubic);
        shape_panel.add(this.e_line);
        shape_panel.add(this.e_wedge);
        shape_panel.add(this.e_quad);
        shape_panel.add(this.e_cubic);
        shape_panel.add(this.e_ortho);
        this.fill_edges = new JCheckBox("fill edge shapes");
        this.fill_edges.setSelected(false);
        this.fill_edges.addActionListener(this);
        shape_panel.add(this.fill_edges);
        shape_panel.setOpaque(true);
        this.e_color = new JCheckBox("highlight edge weights");
        this.e_color.addActionListener(this);
        this.e_labels = new JCheckBox("show edge weight values");
        this.e_labels.addActionListener(this);
        this.e_uarrow_pred = new JCheckBox("undirected");
        this.e_uarrow_pred.addActionListener(this);
        this.e_darrow_pred = new JCheckBox("directed");
        this.e_darrow_pred.addActionListener(this);
        this.e_darrow_pred.setSelected(true);
        this.e_arrow_centered = new JCheckBox("centered");
        this.e_arrow_centered.addActionListener(this);
        JPanel arrow_panel = new JPanel(new GridLayout(1, 0));
        arrow_panel.setBorder(BorderFactory.createTitledBorder("Show arrows"));
        arrow_panel.add(this.e_uarrow_pred);
        arrow_panel.add(this.e_darrow_pred);
        arrow_panel.add(this.e_arrow_centered);
        this.e_show_d = new JCheckBox("directed");
        this.e_show_d.addActionListener(this);
        this.e_show_d.setSelected(true);
        this.e_show_u = new JCheckBox("undirected");
        this.e_show_u.addActionListener(this);
        this.e_show_u.setSelected(true);
        JPanel show_edge_panel = new JPanel(new GridLayout(1, 0));
        show_edge_panel.setBorder(BorderFactory.createTitledBorder("Show edges"));
        show_edge_panel.add(this.e_show_u);
        show_edge_panel.add(this.e_show_d);
        shape_panel.setAlignmentX(0.0f);
        edge_panel.add(shape_panel);
        gradient_panel.setAlignmentX(0.0f);
        edge_panel.add(gradient_panel);
        show_edge_panel.setAlignmentX(0.0f);
        edge_panel.add(show_edge_panel);
        arrow_panel.setAlignmentX(0.0f);
        edge_panel.add(arrow_panel);
        this.e_color.setAlignmentX(0.0f);
        edge_panel.add(this.e_color);
        this.e_labels.setAlignmentX(0.0f);
        edge_panel.add(this.e_labels);
        this.zoom_at_mouse = new JCheckBox("<html><center>zoom at mouse<p>(wheel only)</center></html>");
        this.zoom_at_mouse.addActionListener(this);
        this.zoom_at_mouse.setSelected(true);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(PluggableRendererDemo.this.vv, 1.1f, PluggableRendererDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(PluggableRendererDemo.this.vv, 0.9090909f, PluggableRendererDemo.this.vv.getCenter());
            }
        });
        JPanel zoomPanel = new JPanel();
        zoomPanel.setBorder(BorderFactory.createTitledBorder("Zoom"));
        plus.setAlignmentX(0.5f);
        zoomPanel.add(plus);
        minus.setAlignmentX(0.5f);
        zoomPanel.add(minus);
        this.zoom_at_mouse.setAlignmentX(0.5f);
        zoomPanel.add(this.zoom_at_mouse);
        JPanel fontPanel = new JPanel();
        this.font = new JCheckBox("bold text");
        this.font.addActionListener(this);
        this.font.setAlignmentX(0.5f);
        fontPanel.add(this.font);
        both_panel.add(zoomPanel);
        both_panel.add(fontPanel);
        JComboBox modeBox = this.gm.getModeComboBox();
        modeBox.setAlignmentX(0.5f);
        JPanel modePanel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        modePanel.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        modePanel.add(modeBox);
        JPanel comboGrid = new JPanel(new GridLayout(0, 1));
        comboGrid.add(modePanel);
        fontPanel.add(comboGrid);
        JComboBox<Renderer.VertexLabel.Position> cb = new JComboBox<Renderer.VertexLabel.Position>();
        cb.addItem(Renderer.VertexLabel.Position.N);
        cb.addItem(Renderer.VertexLabel.Position.NE);
        cb.addItem(Renderer.VertexLabel.Position.E);
        cb.addItem(Renderer.VertexLabel.Position.SE);
        cb.addItem(Renderer.VertexLabel.Position.S);
        cb.addItem(Renderer.VertexLabel.Position.SW);
        cb.addItem(Renderer.VertexLabel.Position.W);
        cb.addItem(Renderer.VertexLabel.Position.NW);
        cb.addItem(Renderer.VertexLabel.Position.N);
        cb.addItem(Renderer.VertexLabel.Position.CNTR);
        cb.addItem(Renderer.VertexLabel.Position.AUTO);
        cb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Renderer.VertexLabel.Position position = (Renderer.VertexLabel.Position)e.getItem();
                PluggableRendererDemo.this.vv.getRenderer().getVertexLabelRenderer().setPosition(position);
                PluggableRendererDemo.this.vv.repaint();
            }
        });
        cb.setSelectedItem(Renderer.VertexLabel.Position.SE);
        JPanel positionPanel = new JPanel();
        positionPanel.setBorder(BorderFactory.createTitledBorder("Label Position"));
        positionPanel.add(cb);
        comboGrid.add(positionPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractButton source = (AbstractButton)e.getSource();
        if (source == this.v_color) {
            this.seedFillColor.setSeedColoring(source.isSelected());
        } else if (source == this.e_color) {
            this.ewcs.setWeighted(source.isSelected());
        } else if (source == this.v_stroke) {
            this.vsh.setHighlight(source.isSelected());
        } else if (source == this.v_labels) {
            if (source.isSelected()) {
                this.vv.getRenderContext().setVertexLabelTransformer(this.vs);
            } else {
                this.vv.getRenderContext().setVertexLabelTransformer(this.vs_none);
            }
        } else if (source == this.e_labels) {
            if (source.isSelected()) {
                this.vv.getRenderContext().setEdgeLabelTransformer(this.es);
            } else {
                this.vv.getRenderContext().setEdgeLabelTransformer(this.es_none);
            }
        } else if (source == this.e_uarrow_pred) {
            this.show_arrow.showUndirected(source.isSelected());
        } else if (source == this.e_darrow_pred) {
            this.show_arrow.showDirected(source.isSelected());
        } else if (source == this.e_arrow_centered) {
            if (source.isSelected()) {
                this.vv.getRenderer().getEdgeRenderer().setEdgeArrowRenderingSupport((EdgeArrowRenderingSupport)new CenterEdgeArrowRenderingSupport());
            } else {
                this.vv.getRenderer().getEdgeRenderer().setEdgeArrowRenderingSupport((EdgeArrowRenderingSupport)new BasicEdgeArrowRenderingSupport());
            }
        } else if (source == this.font) {
            this.vff.setBold(source.isSelected());
            this.eff.setBold(source.isSelected());
        } else if (source == this.v_shape) {
            this.vssa.useFunnyShapes(source.isSelected());
        } else if (source == this.v_size) {
            this.vssa.setScaling(source.isSelected());
        } else if (source == this.v_aspect) {
            this.vssa.setStretching(source.isSelected());
        } else if (source == this.e_line) {
            if (source.isSelected()) {
                this.vv.getRenderContext().setEdgeShapeTransformer((Function)EdgeShape.line(this.graph));
            }
        } else if (source == this.e_ortho) {
            if (source.isSelected()) {
                this.vv.getRenderContext().setEdgeShapeTransformer((Function)EdgeShape.orthogonal(this.graph));
            }
        } else if (source == this.e_wedge) {
            if (source.isSelected()) {
                this.vv.getRenderContext().setEdgeShapeTransformer((Function)EdgeShape.wedge(this.graph, (int)10));
            }
        } else if (source == this.e_quad) {
            if (source.isSelected()) {
                this.vv.getRenderContext().setEdgeShapeTransformer((Function)EdgeShape.quadCurve(this.graph));
            }
        } else if (source == this.e_cubic) {
            if (source.isSelected()) {
                this.vv.getRenderContext().setEdgeShapeTransformer((Function)EdgeShape.cubicCurve(this.graph));
            }
        } else if (source == this.e_show_d) {
            this.show_edge.showDirected(source.isSelected());
        } else if (source == this.e_show_u) {
            this.show_edge.showUndirected(source.isSelected());
        } else if (source == this.v_small) {
            this.show_vertex.filterSmall(source.isSelected());
        } else if (source == this.zoom_at_mouse) {
            this.gm.setZoomAtMouse(source.isSelected());
        } else if (source == this.no_gradient) {
            if (source.isSelected()) {
                gradient_level = 0;
            }
        } else if (source == this.gradient_relative) {
            if (source.isSelected()) {
                gradient_level = 1;
            }
        } else if (source == this.fill_edges) {
            if (source.isSelected()) {
                this.vv.getRenderContext().setEdgeFillPaintTransformer(this.edgeFillPaint);
            } else {
                this.vv.getRenderContext().setEdgeFillPaintTransformer(Functions.constant(null));
            }
        }
        this.vv.repaint();
    }

    public class GradientPickedEdgePaintFunction<V, E>
    extends GradientEdgePaintTransformer<V, E> {
        private Function<E, Paint> defaultFunc;
        protected boolean fill_edge;
        Predicate<Context<Graph<V, E>, E>> selfLoop;

        public GradientPickedEdgePaintFunction(Function<E, Paint> defaultEdgePaintFunction, VisualizationViewer<V, E> vv) {
            super(Color.WHITE, Color.BLACK, vv);
            this.fill_edge = false;
            this.selfLoop = new SelfLoopEdgePredicate();
            this.defaultFunc = defaultEdgePaintFunction;
        }

        public void useFill(boolean b) {
            this.fill_edge = b;
        }

        public Paint apply(E e) {
            if (gradient_level == 0) {
                return (Paint)this.defaultFunc.apply(e);
            }
            return super.apply(e);
        }

        protected Color getColor2(E e) {
            return this.vv.getPickedEdgeState().isPicked(e) ? Color.CYAN : this.c2;
        }
    }

    public class VoltageTips<E>
    implements Function<Integer, String> {
        public String apply(Integer vertex) {
            return "Voltage:" + PluggableRendererDemo.this.voltages.apply((Object)vertex);
        }
    }

    protected class PopupGraphMousePlugin
    extends AbstractPopupGraphMousePlugin
    implements MouseListener {
        public PopupGraphMousePlugin() {
            this(4);
        }

        public PopupGraphMousePlugin(int modifiers) {
            super(modifiers);
        }

        protected void handlePopup(MouseEvent e) {
            final VisualizationViewer vv = (VisualizationViewer)e.getSource();
            Point p = e.getPoint();
            GraphElementAccessor pickSupport = vv.getPickSupport();
            if (pickSupport != null) {
                final Integer v = (Integer)pickSupport.getVertex(vv.getGraphLayout(), ((Point2D)p).getX(), ((Point2D)p).getY());
                if (v != null) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(new AbstractAction("Decrease Transparency"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Double value = Math.min(1.0, PluggableRendererDemo.this.transparency.get(v).doubleValue() + 0.1);
                            PluggableRendererDemo.this.transparency.put(v, value);
                            vv.repaint();
                        }
                    });
                    popup.add(new AbstractAction("Increase Transparency"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Double value = Math.max(0.0, PluggableRendererDemo.this.transparency.get(v).doubleValue() - 0.1);
                            PluggableRendererDemo.this.transparency.put(v, value);
                            vv.repaint();
                        }
                    });
                    popup.show((Component)vv, e.getX(), e.getY());
                } else {
                    final Number edge = (Number)pickSupport.getEdge(vv.getGraphLayout(), ((Point2D)p).getX(), ((Point2D)p).getY());
                    if (edge != null) {
                        JPopupMenu popup = new JPopupMenu();
                        popup.add(new AbstractAction(edge.toString()){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                System.err.println("got " + edge);
                            }
                        });
                        popup.show((Component)vv, e.getX(), e.getY());
                    }
                }
            }
        }
    }

    private static final class VertexShapeSizeAspect<V, E>
    extends AbstractVertexShapeTransformer<V>
    implements Function<V, Shape> {
        protected boolean stretch = false;
        protected boolean scale = false;
        protected boolean funny_shapes = false;
        protected Function<V, Double> voltages;
        protected Graph<V, E> graph;

        public VertexShapeSizeAspect(Graph<V, E> graphIn, Function<V, Double> voltagesIn) {
            this.graph = graphIn;
            this.voltages = voltagesIn;
            this.setSizeTransformer(new Function<V, Integer>(){

                public Integer apply(V v) {
                    if (VertexShapeSizeAspect.this.scale) {
                        return (int)((Double)VertexShapeSizeAspect.this.voltages.apply(v) * 30.0) + 20;
                    }
                    return 20;
                }
            });
            this.setAspectRatioTransformer(new Function<V, Float>(){

                public Float apply(V v) {
                    if (VertexShapeSizeAspect.this.stretch) {
                        return Float.valueOf((float)(VertexShapeSizeAspect.this.graph.inDegree(v) + 1) / (float)(VertexShapeSizeAspect.this.graph.outDegree(v) + 1));
                    }
                    return Float.valueOf(1.0f);
                }
            });
        }

        public void setStretching(boolean stretch) {
            this.stretch = stretch;
        }

        public void setScaling(boolean scale) {
            this.scale = scale;
        }

        public void useFunnyShapes(boolean use) {
            this.funny_shapes = use;
        }

        public Shape apply(V v) {
            if (this.funny_shapes) {
                if (this.graph.degree(v) < 5) {
                    int sides = Math.max(this.graph.degree(v), 3);
                    return this.factory.getRegularPolygon(v, sides);
                }
                return this.factory.getRegularStar(v, this.graph.degree(v));
            }
            return this.factory.getEllipse(v);
        }
    }

    private static final class VertexDisplayPredicate<V, E>
    implements Predicate<Context<Graph<V, E>, V>> {
        protected boolean filter_small;
        protected static final int MIN_DEGREE = 4;

        public VertexDisplayPredicate(boolean filter) {
            this.filter_small = filter;
        }

        public void filterSmall(boolean b) {
            this.filter_small = b;
        }

        public boolean apply(Context<Graph<V, E>, V> context) {
            Graph graph = (Graph)context.graph;
            Object v = context.element;
            if (this.filter_small) {
                return graph.degree(v) >= 4;
            }
            return true;
        }
    }

    private static final class DirectionDisplayPredicate<V, E>
    implements Predicate<Context<Graph<V, E>, E>> {
        protected boolean show_d;
        protected boolean show_u;

        public DirectionDisplayPredicate(boolean show_d, boolean show_u) {
            this.show_d = show_d;
            this.show_u = show_u;
        }

        public void showDirected(boolean b) {
            this.show_d = b;
        }

        public void showUndirected(boolean b) {
            this.show_u = b;
        }

        public boolean apply(Context<Graph<V, E>, E> context) {
            Graph graph = (Graph)context.graph;
            Object e = context.element;
            if (graph.getEdgeType(e) == EdgeType.DIRECTED && this.show_d) {
                return true;
            }
            return graph.getEdgeType(e) == EdgeType.UNDIRECTED && this.show_u;
        }
    }

    private static final class EdgeFontTransformer<E>
    implements Function<E, Font> {
        protected boolean bold = false;
        Font f = new Font("Helvetica", 0, 12);
        Font b = new Font("Helvetica", 1, 12);

        private EdgeFontTransformer() {
        }

        public void setBold(boolean bold) {
            this.bold = bold;
        }

        public Font apply(E e) {
            if (this.bold) {
                return this.b;
            }
            return this.f;
        }
    }

    private static final class VertexFontTransformer<V>
    implements Function<V, Font> {
        protected boolean bold = false;
        Font f = new Font("Helvetica", 0, 12);
        Font b = new Font("Helvetica", 1, 12);

        private VertexFontTransformer() {
        }

        public void setBold(boolean bold) {
            this.bold = bold;
        }

        public Font apply(V v) {
            if (this.bold) {
                return this.b;
            }
            return this.f;
        }
    }

    private static final class VertexStrokeHighlight<V, E>
    implements Function<V, Stroke> {
        protected boolean highlight = false;
        protected Stroke heavy = new BasicStroke(5.0f);
        protected Stroke medium = new BasicStroke(3.0f);
        protected Stroke light = new BasicStroke(1.0f);
        protected PickedInfo<V> pi;
        protected Graph<V, E> graph;

        public VertexStrokeHighlight(Graph<V, E> graph, PickedInfo<V> pi) {
            this.graph = graph;
            this.pi = pi;
        }

        public void setHighlight(boolean highlight) {
            this.highlight = highlight;
        }

        public Stroke apply(V v) {
            if (this.highlight) {
                if (this.pi.isPicked(v)) {
                    return this.heavy;
                }
                for (Object w : this.graph.getNeighbors(v)) {
                    if (!this.pi.isPicked(w)) continue;
                    return this.medium;
                }
                return this.light;
            }
            return this.light;
        }
    }

    private static final class EdgeWeightStrokeFunction<E>
    implements Function<E, Stroke> {
        protected static final Stroke basic = new BasicStroke(1.0f);
        protected static final Stroke heavy = new BasicStroke(2.0f);
        protected static final Stroke dotted = RenderContext.DOTTED;
        protected boolean weighted = false;
        protected Map<E, Number> edge_weight;

        public EdgeWeightStrokeFunction(Map<E, Number> edge_weight) {
            this.edge_weight = edge_weight;
        }

        public void setWeighted(boolean weighted) {
            this.weighted = weighted;
        }

        public Stroke apply(E e) {
            if (this.weighted) {
                if (this.drawHeavy(e)) {
                    return heavy;
                }
                return dotted;
            }
            return basic;
        }

        protected boolean drawHeavy(E e) {
            double value = this.edge_weight.get(e).doubleValue();
            return value > 0.7;
        }
    }

    private final class SeedFillColor<V>
    implements Function<V, Paint> {
        protected PickedInfo<V> pi;
        protected static final float dark_value = 0.8f;
        protected static final float light_value = 0.2f;
        protected boolean seed_coloring;

        public SeedFillColor(PickedInfo<V> pi) {
            this.pi = pi;
            this.seed_coloring = false;
        }

        public void setSeedColoring(boolean b) {
            this.seed_coloring = b;
        }

        public Paint apply(V v) {
            float alpha = PluggableRendererDemo.this.transparency.get(v).floatValue();
            if (this.pi.isPicked(v)) {
                return new Color(1.0f, 1.0f, 0.0f, alpha);
            }
            if (this.seed_coloring && PluggableRendererDemo.this.seedVertices.contains(v)) {
                Color dark = new Color(0.0f, 0.0f, 0.8f, alpha);
                Color light = new Color(0.0f, 0.0f, 0.2f, alpha);
                return new GradientPaint(0.0f, 0.0f, dark, 10.0f, 0.0f, light, true);
            }
            return new Color(1.0f, 0.0f, 0.0f, alpha);
        }
    }

    private final class SeedDrawColor<V>
    implements Function<V, Paint> {
        private SeedDrawColor() {
        }

        public Paint apply(V v) {
            return Color.BLACK;
        }
    }
}

