/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.layout.PolarPoint;
import edu.uci.ics.jung.algorithms.layout.RadialTreeLayout;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.graph.DelegateForest;
import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalLensGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.transform.LensSupport;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.shape.HyperbolicShapeTransformer;
import edu.uci.ics.jung.visualization.transform.shape.ViewLensSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadialTreeLensDemo
extends JApplet {
    Forest<String, Integer> graph;
    Supplier<DirectedGraph<String, Integer>> graphFactory = new Supplier<DirectedGraph<String, Integer>>(){

        public DirectedGraph<String, Integer> get() {
            return new DirectedSparseGraph();
        }
    };
    Supplier<Tree<String, Integer>> treeFactory = new Supplier<Tree<String, Integer>>(){

        public Tree<String, Integer> get() {
            return new DelegateTree(RadialTreeLensDemo.this.graphFactory);
        }
    };
    Supplier<Integer> edgeFactory = new Supplier<Integer>(){
        int i = 0;

        public Integer get() {
            return this.i++;
        }
    };
    Supplier<String> vertexFactory = new Supplier<String>(){
        int i = 0;

        public String get() {
            return "V" + this.i++;
        }
    };
    VisualizationServer.Paintable rings;
    String root;
    TreeLayout<String, Integer> layout;
    RadialTreeLayout<String, Integer> radialLayout;
    VisualizationViewer<String, Integer> vv;
    LensSupport hyperbolicViewSupport;
    ScalingControl scaler;

    public RadialTreeLensDemo() {
        this.graph = new DelegateForest();
        this.createTree();
        this.layout = new TreeLayout(this.graph);
        this.radialLayout = new RadialTreeLayout(this.graph);
        this.radialLayout.setSize(new Dimension(600, 600));
        Dimension preferredSize = new Dimension(600, 600);
        DefaultVisualizationModel visualizationModel = new DefaultVisualizationModel(this.radialLayout, preferredSize);
        this.vv = new VisualizationViewer((VisualizationModel)visualizationModel, preferredSize);
        PickedState ps = this.vv.getPickedVertexState();
        PickedState pes = this.vv.getPickedEdgeState();
        this.vv.getRenderContext().setVertexFillPaintTransformer((Function)new PickableVertexPaintTransformer((PickedInfo)ps, (Paint)Color.red, (Paint)Color.yellow));
        this.vv.getRenderContext().setEdgeDrawPaintTransformer((Function)new PickableEdgePaintTransformer((PickedInfo)pes, (Paint)Color.black, (Paint)Color.cyan));
        this.vv.setBackground(Color.white);
        this.vv.getRenderContext().setVertexLabelTransformer((Function)new ToStringLabeller());
        this.vv.getRenderContext().setEdgeShapeTransformer((Function)EdgeShape.line(this.graph));
        this.vv.setVertexToolTipTransformer((Function)new ToStringLabeller());
        Container content = this.getContentPane();
        GraphZoomScrollPane gzsp = new GraphZoomScrollPane(this.vv);
        content.add((Component)gzsp);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        this.rings = new Rings();
        this.vv.addPreRenderPaintable(this.rings);
        this.hyperbolicViewSupport = new ViewLensSupport(this.vv, (LensTransformer)new HyperbolicShapeTransformer(this.vv, this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW)), (ModalGraphMouse)new ModalLensGraphMouse());
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(RadialTreeLensDemo.this.vv, 1.1f, RadialTreeLensDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(RadialTreeLensDemo.this.vv, 0.9090909f, RadialTreeLensDemo.this.vv.getCenter());
            }
        });
        JRadioButton hyperView = new JRadioButton("Hyperbolic View");
        hyperView.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RadialTreeLensDemo.this.hyperbolicViewSupport.activate(e.getStateChange() == 1);
            }
        });
        graphMouse.addItemListener(this.hyperbolicViewSupport.getGraphMouse().getModeListener());
        JMenuBar menubar = new JMenuBar();
        menubar.add(graphMouse.getModeMenu());
        gzsp.setCorner((JComponent)menubar);
        JPanel controls = new JPanel();
        JPanel zoomControls = new JPanel(new GridLayout(2, 1));
        zoomControls.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel hyperControls = new JPanel(new GridLayout(3, 2));
        hyperControls.setBorder(BorderFactory.createTitledBorder("Examiner Lens"));
        zoomControls.add(plus);
        zoomControls.add(minus);
        JPanel modeControls = new JPanel(new BorderLayout());
        modeControls.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        modeControls.add(graphMouse.getModeComboBox());
        hyperControls.add(hyperView);
        controls.add(zoomControls);
        controls.add(hyperControls);
        controls.add(modeControls);
        content.add((Component)controls, "South");
    }

    private void createTree() {
        this.graph.addVertex((Object)"V0");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V0", (Object)"V1");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V0", (Object)"V2");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V1", (Object)"V4");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V2", (Object)"V3");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V2", (Object)"V5");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V4", (Object)"V6");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V4", (Object)"V7");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V3", (Object)"V8");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V6", (Object)"V9");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"V4", (Object)"V10");
        this.graph.addVertex((Object)"A0");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"A0", (Object)"A1");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"A0", (Object)"A2");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"A0", (Object)"A3");
        this.graph.addVertex((Object)"B0");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B0", (Object)"B1");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B0", (Object)"B2");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B1", (Object)"B4");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B2", (Object)"B3");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B2", (Object)"B5");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B4", (Object)"B6");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B4", (Object)"B7");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B3", (Object)"B8");
        this.graph.addEdge(this.edgeFactory.get(), (Object)"B6", (Object)"B9");
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new RadialTreeLensDemo());
        f.pack();
        f.setVisible(true);
    }

    class Rings
    implements VisualizationServer.Paintable {
        Collection<Double> depths = this.getDepths();

        private Collection<Double> getDepths() {
            HashSet<Double> depths = new HashSet<Double>();
            Map polarLocations = RadialTreeLensDemo.this.radialLayout.getPolarLocations();
            for (String v : RadialTreeLensDemo.this.graph.getVertices()) {
                PolarPoint pp = (PolarPoint)polarLocations.get(v);
                depths.add(pp.getRadius());
            }
            return depths;
        }

        public void paint(Graphics g) {
            g.setColor(Color.gray);
            Graphics2D g2d = (Graphics2D)g;
            Point2D center = RadialTreeLensDemo.this.radialLayout.getCenter();
            Ellipse2D.Double ellipse = new Ellipse2D.Double();
            for (double d : this.depths) {
                ellipse.setFrameFromDiagonal(center.getX() - d, center.getY() - d, center.getX() + d, center.getY() + d);
                Shape shape = RadialTreeLensDemo.this.vv.getRenderContext().getMultiLayerTransformer().transform((Shape)ellipse);
                g2d.draw(shape);
            }
        }

        public boolean useTransform() {
            return true;
        }
    }
}

