/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.generators.random.MixedRandomGraphGenerator;
import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.ISOMLayout;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout2;
import edu.uci.ics.jung.algorithms.layout.util.Relaxer;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.util.TestGraphs;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.layout.LayoutTransition;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import edu.uci.ics.jung.visualization.util.Animator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;

public class ShowLayouts
extends JApplet {
    protected static Graph<? extends Object, ? extends Object>[] g_array;
    protected static int graph_index;
    protected static String[] graph_names;

    private static JPanel getGraphPanel() {
        g_array = new Graph[graph_names.length];
        Supplier<Graph<Integer, Number>> graphFactory = new Supplier<Graph<Integer, Number>>(){

            public Graph<Integer, Number> get() {
                return new SparseMultigraph();
            }
        };
        Supplier<Integer> vertexFactory = new Supplier<Integer>(){
            int count;

            public Integer get() {
                return this.count++;
            }
        };
        Supplier<Number> edgeFactory = new Supplier<Number>(){
            int count;

            public Number get() {
                return this.count++;
            }
        };
        ShowLayouts.g_array[0] = TestGraphs.createTestGraph((boolean)false);
        ShowLayouts.g_array[1] = MixedRandomGraphGenerator.generateMixedRandomGraph((Supplier)graphFactory, (Supplier)vertexFactory, (Supplier)edgeFactory, new HashMap(), (int)20, new HashSet());
        ShowLayouts.g_array[2] = TestGraphs.getDemoGraph();
        ShowLayouts.g_array[3] = TestGraphs.createDirectedAcyclicGraph((int)4, (int)4, (double)0.3);
        ShowLayouts.g_array[4] = TestGraphs.getOneComponentGraph();
        ShowLayouts.g_array[5] = TestGraphs.createChainPlusIsolates((int)18, (int)5);
        ShowLayouts.g_array[6] = TestGraphs.createChainPlusIsolates((int)0, (int)20);
        Graph<? extends Object, ? extends Object> g = g_array[4];
        final VisualizationViewer vv = new VisualizationViewer((Layout)new FRLayout(g));
        vv.getRenderContext().setVertexFillPaintTransformer((Function)new PickableVertexPaintTransformer((PickedInfo)vv.getPickedVertexState(), (Paint)Color.red, (Paint)Color.yellow));
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler, vv){
            final /* synthetic */ ScalingControl val$scaler;
            final /* synthetic */ VisualizationViewer val$vv;
            {
                this.val$scaler = scalingControl;
                this.val$vv = visualizationViewer;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale((VisualizationServer)this.val$vv, 1.1f, this.val$vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler, vv){
            final /* synthetic */ ScalingControl val$scaler;
            final /* synthetic */ VisualizationViewer val$vv;
            {
                this.val$scaler = scalingControl;
                this.val$vv = visualizationViewer;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale((VisualizationServer)this.val$vv, 0.9090909f, this.val$vv.getCenter());
            }
        });
        JButton reset = new JButton("reset");
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Layout layout = vv.getGraphLayout();
                layout.initialize();
                Relaxer relaxer = vv.getModel().getRelaxer();
                if (relaxer != null) {
                    relaxer.stop();
                    relaxer.prerelax();
                    relaxer.relax();
                }
            }
        });
        JComboBox modeBox = graphMouse.getModeComboBox();
        modeBox.addItemListener(((DefaultModalGraphMouse)vv.getGraphMouse()).getModeListener());
        JPanel jp = new JPanel();
        jp.setBackground(Color.WHITE);
        jp.setLayout(new BorderLayout());
        jp.add((Component)vv, "Center");
        Class<? extends Layout>[] combos = ShowLayouts.getCombos();
        JComboBox<Class<? extends Layout>> jcb = new JComboBox<Class<? extends Layout>>(combos);
        jcb.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String valueString = value.toString();
                valueString = valueString.substring(valueString.lastIndexOf(46) + 1);
                return super.getListCellRendererComponent((JList<?>)list, valueString, index, isSelected, cellHasFocus);
            }
        });
        jcb.addActionListener(new LayoutChooser(jcb, vv));
        jcb.setSelectedItem(FRLayout.class);
        JPanel control_panel = new JPanel(new GridLayout(2, 1));
        JPanel topControls = new JPanel();
        JPanel bottomControls = new JPanel();
        control_panel.add(topControls);
        control_panel.add(bottomControls);
        jp.add((Component)control_panel, "North");
        JComboBox<String> graph_chooser = new JComboBox<String>(graph_names);
        graph_chooser.addActionListener(new GraphChooser(jcb));
        topControls.add(jcb);
        topControls.add(graph_chooser);
        bottomControls.add(plus);
        bottomControls.add(minus);
        bottomControls.add(modeBox);
        bottomControls.add(reset);
        return jp;
    }

    @Override
    public void start() {
        this.getContentPane().add(ShowLayouts.getGraphPanel());
    }

    private static Class<? extends Layout>[] getCombos() {
        ArrayList<Class> layouts = new ArrayList<Class>();
        layouts.add(KKLayout.class);
        layouts.add(FRLayout.class);
        layouts.add(CircleLayout.class);
        layouts.add(SpringLayout.class);
        layouts.add(SpringLayout2.class);
        layouts.add(ISOMLayout.class);
        return layouts.toArray(new Class[0]);
    }

    public static void main(String[] args) {
        JPanel jp = ShowLayouts.getGraphPanel();
        JFrame jf = new JFrame();
        jf.getContentPane().add(jp);
        jf.setDefaultCloseOperation(3);
        jf.pack();
        jf.setVisible(true);
    }

    static {
        graph_names = new String[]{"Two component graph", "Random mixed-mode graph", "Miscellaneous multicomponent graph", "Random directed acyclic graph", "One component graph", "Chain+isolate graph", "Trivial (disconnected) graph"};
    }

    private static final class LayoutChooser
    implements ActionListener {
        private final JComboBox<?> jcb;
        private final VisualizationViewer<Integer, Number> vv;

        private LayoutChooser(JComboBox<?> jcb, VisualizationViewer<Integer, Number> vv) {
            this.jcb = jcb;
            this.vv = vv;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Object[] constructorArgs = new Object[]{g_array[graph_index]};
            Class layoutC = (Class)this.jcb.getSelectedItem();
            try {
                Constructor constructor = layoutC.getConstructor(Graph.class);
                Object o = constructor.newInstance(constructorArgs);
                Layout l = (Layout)o;
                l.setInitializer((Function)this.vv.getGraphLayout());
                l.setSize(this.vv.getSize());
                LayoutTransition lt = new LayoutTransition(this.vv, this.vv.getGraphLayout(), l);
                Animator animator = new Animator((IterativeContext)lt);
                animator.start();
                this.vv.getRenderContext().getMultiLayerTransformer().setToIdentity();
                this.vv.repaint();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class GraphChooser
    implements ActionListener {
        private JComboBox<?> layout_combo;

        public GraphChooser(JComboBox<?> layout_combo) {
            this.layout_combo = layout_combo;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            graph_index = cb.getSelectedIndex();
            this.layout_combo.setSelectedIndex(this.layout_combo.getSelectedIndex());
        }
    }
}

