/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.AggregateLayout;
import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.graph.util.TestGraphs;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import edu.uci.ics.jung.visualization.picking.PickedState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SubLayoutDemo
extends JApplet {
    String instructions = "<html>Use the Layout combobox to select the <p>underlying layout.<p>Use the SubLayout combobox to select <p>the type of layout for any clusters you create.<p>To create clusters, use the mouse to select <p>multiple vertices, either by dragging a region, <p>or by shift-clicking on multiple vertices.<p>After you select vertices, use the <p>Cluster Picked button to cluster them using the <p>layout and size specified in the Sublayout comboboxen.<p>Use the Uncluster All button to remove all<p>clusters.<p>You can drag the cluster with the mouse.<p>Use the 'Picking'/'Transforming' combo-box to switch<p>between picking and transforming mode.</html>";
    Graph<String, Number> graph;
    Map<Graph<String, Number>, Dimension> sizes = new HashMap<Graph<String, Number>, Dimension>();
    Class<Layout>[] layoutClasses = new Class[]{CircleLayout.class, SpringLayout.class, FRLayout.class, KKLayout.class};
    VisualizationViewer<String, Number> vv;
    AggregateLayout<String, Number> clusteringLayout;
    Dimension subLayoutSize;
    PickedState<String> ps;
    Class<CircleLayout> subLayoutType = CircleLayout.class;

    public SubLayoutDemo() {
        this.graph = TestGraphs.getOneComponentGraph();
        this.clusteringLayout = new AggregateLayout((Layout)new FRLayout(this.graph));
        Dimension preferredSize = new Dimension(600, 600);
        DefaultVisualizationModel visualizationModel = new DefaultVisualizationModel(this.clusteringLayout, preferredSize);
        this.vv = new VisualizationViewer((VisualizationModel)visualizationModel, preferredSize);
        this.ps = this.vv.getPickedVertexState();
        this.vv.getRenderContext().setEdgeDrawPaintTransformer((Function)new PickableEdgePaintTransformer((PickedInfo)this.vv.getPickedEdgeState(), (Paint)Color.black, (Paint)Color.red));
        this.vv.getRenderContext().setVertexFillPaintTransformer((Function)new PickableVertexPaintTransformer((PickedInfo)this.vv.getPickedVertexState(), (Paint)Color.red, (Paint)Color.yellow));
        this.vv.setBackground(Color.white);
        this.vv.setVertexToolTipTransformer((Function)new ToStringLabeller());
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        Container content = this.getContentPane();
        GraphZoomScrollPane gzsp = new GraphZoomScrollPane(this.vv);
        content.add((Component)gzsp);
        JComboBox modeBox = graphMouse.getModeComboBox();
        modeBox.addItemListener(graphMouse.getModeListener());
        graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(SubLayoutDemo.this.vv, 1.1f, SubLayoutDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(SubLayoutDemo.this.vv, 0.9090909f, SubLayoutDemo.this.vv.getCenter());
            }
        });
        JButton cluster = new JButton("Cluster Picked");
        cluster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubLayoutDemo.this.clusterPicked();
            }
        });
        JButton uncluster = new JButton("UnCluster All");
        uncluster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubLayoutDemo.this.uncluster();
            }
        });
        JComboBox<Class<Layout>> layoutTypeComboBox = new JComboBox<Class<Layout>>(this.layoutClasses);
        layoutTypeComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String valueString = value.toString();
                valueString = valueString.substring(valueString.lastIndexOf(46) + 1);
                return super.getListCellRendererComponent(list, valueString, index, isSelected, cellHasFocus);
            }
        });
        layoutTypeComboBox.setSelectedItem(FRLayout.class);
        layoutTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Class clazz = (Class)e.getItem();
                    try {
                        Layout layout = SubLayoutDemo.this.getLayoutFor(clazz, (Graph<String, Number>)SubLayoutDemo.this.graph);
                        layout.setInitializer((Function)SubLayoutDemo.this.vv.getGraphLayout());
                        SubLayoutDemo.this.clusteringLayout.setDelegate(layout);
                        SubLayoutDemo.this.vv.setGraphLayout(SubLayoutDemo.this.clusteringLayout);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        JComboBox<Class<Layout>> subLayoutTypeComboBox = new JComboBox<Class<Layout>>(this.layoutClasses);
        subLayoutTypeComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String valueString = value.toString();
                valueString = valueString.substring(valueString.lastIndexOf(46) + 1);
                return super.getListCellRendererComponent(list, valueString, index, isSelected, cellHasFocus);
            }
        });
        subLayoutTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SubLayoutDemo.this.subLayoutType = (Class)e.getItem();
                }
            }
        });
        JComboBox<Dimension> subLayoutDimensionComboBox = new JComboBox<Dimension>(new Dimension[]{new Dimension(75, 75), new Dimension(100, 100), new Dimension(150, 150), new Dimension(200, 200), new Dimension(250, 250), new Dimension(300, 300)});
        subLayoutDimensionComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String valueString = value.toString();
                valueString = valueString.substring(valueString.lastIndexOf(91));
                valueString = valueString.replaceAll("idth", "");
                valueString = valueString.replaceAll("eight", "");
                return super.getListCellRendererComponent(list, valueString, index, isSelected, cellHasFocus);
            }
        });
        subLayoutDimensionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SubLayoutDemo.this.subLayoutSize = (Dimension)e.getItem();
                }
            }
        });
        subLayoutDimensionComboBox.setSelectedIndex(1);
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog((JComponent)e.getSource(), SubLayoutDemo.this.instructions, "Help", -1);
            }
        });
        Dimension space = new Dimension(20, 20);
        Box controls = Box.createVerticalBox();
        controls.add(Box.createRigidArea(space));
        JPanel zoomControls = new JPanel(new GridLayout(1, 2));
        zoomControls.setBorder(BorderFactory.createTitledBorder("Zoom"));
        zoomControls.add(plus);
        zoomControls.add(minus);
        this.heightConstrain(zoomControls);
        controls.add(zoomControls);
        controls.add(Box.createRigidArea(space));
        JPanel clusterControls = new JPanel(new GridLayout(0, 1));
        clusterControls.setBorder(BorderFactory.createTitledBorder("Clustering"));
        clusterControls.add(cluster);
        clusterControls.add(uncluster);
        this.heightConstrain(clusterControls);
        controls.add(clusterControls);
        controls.add(Box.createRigidArea(space));
        JPanel layoutControls = new JPanel(new GridLayout(0, 1));
        layoutControls.setBorder(BorderFactory.createTitledBorder("Layout"));
        layoutControls.add(layoutTypeComboBox);
        this.heightConstrain(layoutControls);
        controls.add(layoutControls);
        JPanel subLayoutControls = new JPanel(new GridLayout(0, 1));
        subLayoutControls.setBorder(BorderFactory.createTitledBorder("SubLayout"));
        subLayoutControls.add(subLayoutTypeComboBox);
        subLayoutControls.add(subLayoutDimensionComboBox);
        this.heightConstrain(subLayoutControls);
        controls.add(subLayoutControls);
        controls.add(Box.createRigidArea(space));
        JPanel modePanel = new JPanel(new GridLayout(1, 1));
        modePanel.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        modePanel.add(modeBox);
        this.heightConstrain(modePanel);
        controls.add(modePanel);
        controls.add(Box.createRigidArea(space));
        controls.add(help);
        controls.add(Box.createVerticalGlue());
        content.add((Component)controls, "East");
    }

    private void heightConstrain(Component component) {
        Dimension d = new Dimension(component.getMaximumSize().width, component.getMinimumSize().height);
        component.setMaximumSize(d);
    }

    private Layout<String, Number> getLayoutFor(Class<CircleLayout> layoutClass, Graph<String, Number> graph) throws Exception {
        Object[] args = new Object[]{graph};
        Constructor<CircleLayout> constructor = layoutClass.getConstructor(Graph.class);
        return (Layout)constructor.newInstance(args);
    }

    private void clusterPicked() {
        this.cluster(true);
    }

    private void uncluster() {
        this.cluster(false);
    }

    private void cluster(boolean state) {
        if (state) {
            Set picked = this.ps.getPicked();
            if (picked.size() > 1) {
                Point2D.Double center = new Point2D.Double();
                double x = 0.0;
                double y = 0.0;
                for (Object vertex : picked) {
                    Point2D p = this.clusteringLayout.apply(vertex);
                    x += p.getX();
                    y += p.getY();
                }
                ((Point2D)center).setLocation(x /= (double)picked.size(), y /= (double)picked.size());
                try {
                    Graph subGraph = (Graph)this.graph.getClass().newInstance();
                    for (String vertex : picked) {
                        subGraph.addVertex((Object)vertex);
                        Collection incidentEdges = this.graph.getIncidentEdges((Object)vertex);
                        for (Number edge : incidentEdges) {
                            Pair endpoints = this.graph.getEndpoints((Object)edge);
                            if (!picked.containsAll((Collection<?>)endpoints)) continue;
                            subGraph.addEdge((Object)edge, endpoints.getFirst(), endpoints.getSecond());
                        }
                    }
                    Layout<String, Number> subLayout = this.getLayoutFor(this.subLayoutType, (Graph<String, Number>)subGraph);
                    subLayout.setInitializer((Function)this.vv.getGraphLayout());
                    subLayout.setSize(this.subLayoutSize);
                    this.clusteringLayout.put(subLayout, (Point2D)center);
                    this.vv.setGraphLayout(this.clusteringLayout);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.clusteringLayout.removeAll();
            this.vv.setGraphLayout(this.clusteringLayout);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new SubLayoutDemo());
        f.pack();
        f.setVisible(true);
    }
}

