/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.TestGraphs;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.DefaultVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.GradientVertexRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.renderers.VertexLabelAsShapeRenderer;
import edu.uci.ics.jung.visualization.renderers.VertexLabelRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class VertexLabelAsShapeDemo
extends JApplet {
    private static final long serialVersionUID = 1017336668368978842L;
    Graph<String, Number> graph = TestGraphs.getOneComponentGraph();
    VisualizationViewer<String, Number> vv;
    Layout<String, Number> layout = new FRLayout(this.graph);

    public VertexLabelAsShapeDemo() {
        Dimension preferredSize = new Dimension(400, 400);
        DefaultVisualizationModel visualizationModel = new DefaultVisualizationModel(this.layout, preferredSize);
        this.vv = new VisualizationViewer((VisualizationModel)visualizationModel, preferredSize);
        VertexLabelAsShapeRenderer vlasr = new VertexLabelAsShapeRenderer(this.vv.getRenderContext());
        this.vv.getRenderContext().setVertexLabelTransformer(Functions.compose((Function)new Function<String, String>(){

            public String apply(String input) {
                return "<html><center>Vertex<p>" + input;
            }
        }, (Function)new ToStringLabeller()));
        this.vv.getRenderContext().setVertexShapeTransformer((Function)vlasr);
        this.vv.getRenderContext().setVertexLabelRenderer((VertexLabelRenderer)new DefaultVertexLabelRenderer(Color.red));
        this.vv.getRenderContext().setEdgeDrawPaintTransformer(Functions.constant((Object)Color.yellow));
        this.vv.getRenderContext().setEdgeStrokeTransformer(Functions.constant((Object)new BasicStroke(2.5f)));
        this.vv.getRenderer().setVertexRenderer((Renderer.Vertex)new GradientVertexRenderer(Color.gray, Color.white, true));
        this.vv.getRenderer().setVertexLabelRenderer((Renderer.VertexLabel)vlasr);
        this.vv.setBackground(Color.black);
        this.vv.setVertexToolTipTransformer((Function)new ToStringLabeller());
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        Container content = this.getContentPane();
        GraphZoomScrollPane gzsp = new GraphZoomScrollPane(this.vv);
        content.add((Component)gzsp);
        JComboBox modeBox = graphMouse.getModeComboBox();
        modeBox.addItemListener(graphMouse.getModeListener());
        graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(VertexLabelAsShapeDemo.this.vv, 1.1f, VertexLabelAsShapeDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(VertexLabelAsShapeDemo.this.vv, 0.9090909f, VertexLabelAsShapeDemo.this.vv.getCenter());
            }
        });
        JPanel controls = new JPanel();
        JPanel zoomControls = new JPanel(new GridLayout(2, 1));
        zoomControls.setBorder(BorderFactory.createTitledBorder("Zoom"));
        zoomControls.add(plus);
        zoomControls.add(minus);
        controls.add(zoomControls);
        controls.add(modeBox);
        content.add((Component)controls, "South");
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new VertexLabelAsShapeDemo());
        f.pack();
        f.setVisible(true);
    }
}

