/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.util.ArrayList;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.Synset;

public class Word
extends PointerTarget {
    private static final long serialVersionUID = 8591237840924027785L;
    private Synset _synset;
    private int _index;
    private String _lemma;
    protected int lexId;
    private transient String _cachedToString = null;

    public int getLexId() {
        return this.lexId;
    }

    public void setLexId(int lexId) {
        this.lexId = lexId;
    }

    public Word(Synset synset, int index, String lemma) {
        this._synset = synset;
        this._index = index;
        this._lemma = lemma;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Word && ((Word)object).getSynset().equals(this.getSynset()) && ((Word)object).getIndex() == this.getIndex();
    }

    public int hashCode() {
        return this.getSynset().hashCode() ^ this.getIndex();
    }

    @Override
    public String toString() {
        if (this._cachedToString == null) {
            Object[] params = new Object[]{this.getPOS(), this.getLemma(), this.getSynset(), new Integer(this.getIndex())};
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_005", params);
        }
        return this._cachedToString;
    }

    public Synset getSynset() {
        return this._synset;
    }

    @Override
    public POS getPOS() {
        return this._synset.getPOS();
    }

    public int getIndex() {
        return this._index;
    }

    public String getLemma() {
        return this._lemma;
    }

    @Override
    public Pointer[] getPointers() {
        Pointer[] source = this.getSynset().getPointers();
        ArrayList<Pointer> list = new ArrayList<Pointer>(source.length);
        for (int i = 0; i < source.length; ++i) {
            Pointer pointer = source[i];
            if (!this.equals(pointer.getSource())) continue;
            list.add(pointer);
        }
        return list.toArray(new Pointer[list.size()]);
    }
}

