/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data.relationship;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.list.PointerTargetNode;
import net.didion.jwnl.data.list.PointerTargetNodeList;

public abstract class Relationship {
    private PointerTargetNodeList _nodes;
    private PointerType _type;
    private Synset _sourceSynset;
    private Synset _targetSynset;

    protected Relationship(PointerType type, PointerTargetNodeList nodes, Synset sourceSynset, Synset targetSynset) {
        this._type = type;
        this._nodes = nodes;
        this._sourceSynset = sourceSynset;
        this._targetSynset = targetSynset;
    }

    public abstract Relationship reverse();

    public PointerTargetNodeList getNodeList() {
        return this._nodes;
    }

    public PointerTarget getSourcePointerTarget() {
        return ((PointerTargetNode)this._nodes.get(0)).getPointerTarget();
    }

    public PointerTarget getTargetPointerTarget() {
        return ((PointerTargetNode)this._nodes.get(this._nodes.size() - 1)).getPointerTarget();
    }

    public String toString() {
        StringBufferOutputStream stream = new StringBufferOutputStream();
        this._nodes.print(new PrintStream(stream));
        return stream.getStringBuffer().toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Relationship) {
            Relationship r = (Relationship)obj;
            return r.getType().equals(this.getType()) && r.getSourceSynset().equals(this.getSourceSynset()) && r.getTargetSynset().equals(this.getTargetSynset());
        }
        return false;
    }

    public PointerType getType() {
        return this._type;
    }

    public Synset getSourceSynset() {
        return this._sourceSynset;
    }

    public Synset getTargetSynset() {
        return this._targetSynset;
    }

    public int getSize() {
        return this.getNodeList().size();
    }

    public int getDepth() {
        return this.getSize() - 1;
    }

    private static class StringBufferOutputStream
    extends OutputStream {
        private StringWriter writer = new StringWriter();

        private StringBufferOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.writer.write(b);
        }

        public StringBuffer getStringBuffer() {
            return this.writer.getBuffer();
        }
    }
}

