/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary.file_manager;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.file.DictionaryCatalogSet;
import net.didion.jwnl.dictionary.file.DictionaryFile;
import net.didion.jwnl.dictionary.file.DictionaryFileType;
import net.didion.jwnl.dictionary.file.RandomAccessDictionaryFile;
import net.didion.jwnl.dictionary.file_manager.FileManager;
import net.didion.jwnl.util.factory.Param;

public class FileManagerImpl
implements FileManager {
    public static final String FILE_TYPE = "file_type";
    public static final String PATH = "dictionary_path";
    private static final Random _rand = new Random(new Date().getTime());
    private DictionaryCatalogSet _files;

    public FileManagerImpl() {
    }

    public FileManagerImpl(String searchDir, Class dictionaryFileType) throws IOException {
        this.checkFileType(dictionaryFileType);
        this._files = new DictionaryCatalogSet(searchDir, dictionaryFileType);
        this._files.open();
    }

    @Override
    public Object create(Map params) throws JWNLException {
        Class<?> fileClass = null;
        try {
            fileClass = Class.forName(((Param)params.get(FILE_TYPE)).getValue());
        }
        catch (ClassNotFoundException ex) {
            throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_002", ex);
        }
        this.checkFileType(fileClass);
        String path = ((Param)params.get(PATH)).getValue();
        try {
            return new FileManagerImpl(path, fileClass);
        }
        catch (IOException ex) {
            throw new JWNLException("DICTIONARY_EXCEPTION_016", fileClass, (Throwable)ex);
        }
    }

    private void checkFileType(Class c) {
        if (!DictionaryFile.class.isAssignableFrom(c)) {
            throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_003", c);
        }
    }

    @Override
    public void close() {
        this._files.close();
    }

    public DictionaryFile getFile(POS pos, DictionaryFileType fileType) {
        return this._files.getDictionaryFile(pos, fileType);
    }

    private void skipLine(RandomAccessDictionaryFile file) throws IOException {
        int c;
        while ((c = file.read()) != -1 && c != 10 && c != 13) {
        }
        c = file.read();
        if (c != 10 && c != 13) {
            file.seek(file.getFilePointer() - 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readLineAt(POS pos, DictionaryFileType fileType, long offset) throws IOException {
        RandomAccessDictionaryFile file;
        RandomAccessDictionaryFile randomAccessDictionaryFile = file = (RandomAccessDictionaryFile)this.getFile(pos, fileType);
        synchronized (randomAccessDictionaryFile) {
            file.seek(offset);
            String line = file.readLine();
            long nextOffset = file.getFilePointer();
            if (line == null) {
                nextOffset = -1L;
            }
            file.setNextLineOffset(offset, nextOffset);
            return line;
        }
    }

    private String readLineWord(RandomAccessDictionaryFile file) throws IOException {
        int c;
        StringBuffer input = new StringBuffer();
        while ((c = file.read()) != -1 && c != 10 && c != 13 && c != 32) {
            input.append((char)c);
        }
        return input.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextLinePointer(POS pos, DictionaryFileType fileType, long offset) throws IOException {
        RandomAccessDictionaryFile file;
        RandomAccessDictionaryFile randomAccessDictionaryFile = file = (RandomAccessDictionaryFile)this.getFile(pos, fileType);
        synchronized (randomAccessDictionaryFile) {
            if (file.isPreviousLineOffset(offset) && offset != file.getNextLineOffset()) {
                return file.getNextLineOffset();
            }
            file.seek(offset);
            this.skipLine(file);
            return file.getFilePointer();
        }
    }

    @Override
    public long getMatchingLinePointer(POS pos, DictionaryFileType fileType, long offset, String substring) throws IOException {
        RandomAccessDictionaryFile file = (RandomAccessDictionaryFile)this.getFile(pos, fileType);
        if (file == null || file.length() == 0L) {
            return -1L;
        }
        RandomAccessDictionaryFile randomAccessDictionaryFile = file;
        synchronized (randomAccessDictionaryFile) {
            file.seek(offset);
            while (true) {
                String line = this.readLineWord(file);
                long nextOffset = file.getFilePointer();
                if (line == null) {
                    return -1L;
                }
                file.setNextLineOffset(offset, nextOffset);
                if (line.indexOf(substring) >= 0) {
                    return offset;
                }
                offset = nextOffset;
            }
        }
    }

    @Override
    public long getIndexedLinePointer(POS pos, DictionaryFileType fileType, String target) throws IOException {
        RandomAccessDictionaryFile file = (RandomAccessDictionaryFile)this.getFile(pos, fileType);
        if (file == null || file.length() == 0L) {
            return -1L;
        }
        RandomAccessDictionaryFile randomAccessDictionaryFile = file;
        synchronized (randomAccessDictionaryFile) {
            long start = 0L;
            long stop = file.length();
            long offset = start;
            while (true) {
                String word;
                long midpoint = (start + stop) / 2L;
                file.seek(midpoint);
                file.readLine();
                offset = file.getFilePointer();
                if (stop == offset) {
                    file.seek(start);
                    offset = file.getFilePointer();
                    while (offset != stop) {
                        word = this.readLineWord(file);
                        if (word.equals(target)) {
                            return offset;
                        }
                        file.readLine();
                        offset = file.getFilePointer();
                    }
                    return -1L;
                }
                word = this.readLineWord(file);
                int compare = word.compareTo(target);
                if (compare == 0) {
                    return offset;
                }
                if (compare > 0) {
                    stop = offset;
                    continue;
                }
                start = offset;
            }
        }
    }

    @Override
    public long getRandomLinePointer(POS pos, DictionaryFileType fileType) throws IOException {
        long fileLength = ((RandomAccessDictionaryFile)this.getFile(pos, fileType)).length();
        long start = this.getFirstLinePointer(pos, fileType);
        long offset = start + (long)_rand.nextInt((int)fileLength - (int)start);
        return this.getNextLinePointer(pos, fileType, offset);
    }

    @Override
    public long getFirstLinePointer(POS pos, DictionaryFileType fileType) throws IOException {
        long offset = 0L;
        RandomAccessDictionaryFile file = (RandomAccessDictionaryFile)this.getFile(pos, fileType);
        String line = null;
        line = null;
        while (line == null || line.trim().length() == 0) {
            offset = this.getNextLinePointer(pos, fileType, offset);
            line = this.readLineWord(file);
        }
        return offset;
    }
}

