/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.reader;

import java.util.Date;
import net.sf.jxls.reader.DateConverter;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortConverter;

public class ReaderConfig {
    private static ReaderConfig ourInstance = new ReaderConfig();
    private boolean skipErrors = false;
    private boolean useDefaultValuesForPrimitiveTypes = true;
    private Character defaultCharacter = new Character(' ');
    private Byte defaultByte = new Byte(0);
    private Boolean defaultBoolean = Boolean.FALSE;
    private Double defaultDouble = new Double(0.0);
    private Float defaultFloat = new Float(0.0f);
    private Integer defaultInteger = new Integer(0);
    private Long defaultLong = new Long(0L);
    private static Short defaultShort = new Short(0);

    public static ReaderConfig getInstance() {
        return ourInstance;
    }

    private ReaderConfig() {
        this.setUseDefaultValuesForPrimitiveTypes(false);
        ConvertUtils.register((Converter)new DateConverter(), Date.class);
    }

    public boolean isSkipErrors() {
        return this.skipErrors;
    }

    public void setSkipErrors(boolean skipErrors) {
        this.skipErrors = skipErrors;
    }

    public boolean isUseDefaultValuesForPrimitiveTypes() {
        return this.useDefaultValuesForPrimitiveTypes;
    }

    public void setUseDefaultValuesForPrimitiveTypes(boolean useDefaultValuesForPrimitiveTypes) {
        CharacterConverter characterConverter;
        FloatConverter floatConverter;
        BooleanConverter booleanConverter;
        ShortConverter shortConverter;
        LongConverter longConverter;
        DoubleConverter doubleConverter;
        ByteConverter byteConverter;
        IntegerConverter integerConverter;
        this.useDefaultValuesForPrimitiveTypes = useDefaultValuesForPrimitiveTypes;
        if (useDefaultValuesForPrimitiveTypes) {
            integerConverter = new IntegerConverter((Object)this.defaultInteger);
            byteConverter = new ByteConverter((Object)this.defaultByte);
            doubleConverter = new DoubleConverter((Object)this.defaultDouble);
            longConverter = new LongConverter((Object)this.defaultLong);
            shortConverter = new ShortConverter((Object)defaultShort);
            booleanConverter = new BooleanConverter((Object)this.defaultBoolean);
            floatConverter = new FloatConverter((Object)this.defaultFloat);
            characterConverter = new CharacterConverter((Object)this.defaultCharacter);
        } else {
            integerConverter = new IntegerConverter();
            byteConverter = new ByteConverter();
            doubleConverter = new DoubleConverter();
            longConverter = new LongConverter();
            shortConverter = new ShortConverter();
            booleanConverter = new BooleanConverter();
            floatConverter = new FloatConverter();
            characterConverter = new CharacterConverter();
        }
        ConvertUtils.register((Converter)integerConverter, Integer.TYPE);
        ConvertUtils.register((Converter)integerConverter, Integer.class);
        ConvertUtils.register((Converter)byteConverter, Byte.TYPE);
        ConvertUtils.register((Converter)byteConverter, Byte.class);
        ConvertUtils.register((Converter)doubleConverter, Double.TYPE);
        ConvertUtils.register((Converter)doubleConverter, Double.class);
        ConvertUtils.register((Converter)longConverter, Long.TYPE);
        ConvertUtils.register((Converter)longConverter, Long.class);
        ConvertUtils.register((Converter)shortConverter, Short.TYPE);
        ConvertUtils.register((Converter)shortConverter, Short.class);
        ConvertUtils.register((Converter)booleanConverter, Boolean.TYPE);
        ConvertUtils.register((Converter)booleanConverter, Boolean.class);
        ConvertUtils.register((Converter)floatConverter, Float.TYPE);
        ConvertUtils.register((Converter)floatConverter, Float.class);
        ConvertUtils.register((Converter)characterConverter, Character.TYPE);
        ConvertUtils.register((Converter)characterConverter, Character.class);
    }
}

