/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.code.api;

import net.sf.mmm.code.api.CodeFactory;
import net.sf.mmm.code.api.CodeFile;
import net.sf.mmm.code.api.CodeName;
import net.sf.mmm.code.api.CodeProvider;
import net.sf.mmm.code.api.imports.CodeImport;
import net.sf.mmm.code.api.language.CodeLanguage;
import net.sf.mmm.code.api.type.CodeType;
import net.sf.mmm.code.api.type.CodeTypeWildcard;

public interface CodeContext
extends CodeProvider {
    public CodeLanguage getLanguage();

    @Override
    public CodeContext getParent();

    public CodeType getRootType();

    public CodeTypeWildcard getUnboundedWildcard();

    public CodeType getRootEnumerationType();

    public CodeType getVoidType();

    public CodeType getBooleanType(boolean var1);

    public CodeType getRootExceptionType();

    default public String getQualifiedName(String simpleName, CodeType owningType, boolean omitStandardPackages) {
        if (owningType.getSimpleName().equals(simpleName)) {
            return owningType.getQualifiedName();
        }
        CodeFile file = owningType.getFile();
        return this.getQualifiedName(simpleName, file, omitStandardPackages);
    }

    default public String getQualifiedName(String simpleName, CodeFile file, boolean omitStandardPackages) {
        char separator = this.getLanguage().getPackageSeparator();
        String suffix = separator + simpleName;
        for (CodeImport imp : file.getImports()) {
            String reference;
            if (imp.isStatic() || !(reference = imp.getReference()).endsWith(suffix)) continue;
            return reference;
        }
        String qname = this.getQualifiedNameForStandardType(simpleName, omitStandardPackages);
        if (qname != null) {
            return qname;
        }
        String pkgName = file.getParentPackage().getQualifiedName();
        if (pkgName.isEmpty()) {
            return simpleName;
        }
        return pkgName + suffix;
    }

    public String getQualifiedNameForStandardType(String var1, boolean var2);

    public CodeFactory getFactory();

    default public CodeType getOrCreateType(String qualifiedName, boolean add) {
        CodeType type = this.getType(qualifiedName);
        if (type == null) {
            CodeName path = new CodeName(qualifiedName, this.getLanguage().getPackageSeparator());
            CodeFile file = this.getSource().getRootPackage().getChildren().getOrCreateFile(path, add);
            type = file.getType();
        }
        return type;
    }

    public CodeContext createChildContext();
}

