/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.code.api.copy;

import java.util.HashMap;
import java.util.Map;
import net.sf.mmm.code.api.copy.CodeCopyMapper;
import net.sf.mmm.code.api.copy.CodeCopyType;
import net.sf.mmm.code.api.node.CodeNode;
import net.sf.mmm.util.exception.api.DuplicateObjectException;

public abstract class AbstractCodeCopyMapper
implements CodeCopyMapper {
    private final Map<CodeNode, CodeNode> mapping = new HashMap<CodeNode, CodeNode>();

    @Override
    public <N extends CodeNode> N map(N node, CodeCopyType type) {
        if (node == null) {
            return null;
        }
        N result = this.getMapping(node);
        if (result == null && !this.mapping.containsKey(node)) {
            result = this.doMap(node, type);
        }
        return result;
    }

    protected <N extends CodeNode> N getMapping(N node) {
        return (N)this.mapping.get(node);
    }

    protected abstract <N extends CodeNode> N doMap(N var1, CodeCopyType var2);

    public <N extends CodeNode> void registerMapping(N source, N target) {
        CodeNode duplicate = this.mapping.put(source, target);
        if (duplicate != null) {
            throw new DuplicateObjectException(target, source, (Object)duplicate);
        }
    }
}

