/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.code.api.language;

import java.util.regex.Pattern;
import net.sf.mmm.code.api.CodeFile;
import net.sf.mmm.code.api.CodePackage;
import net.sf.mmm.code.api.item.CodeItem;
import net.sf.mmm.code.api.item.CodeItemWithName;
import net.sf.mmm.code.api.item.CodeItemWithQualifiedName;
import net.sf.mmm.code.api.language.CodeLanguage;
import net.sf.mmm.code.api.type.CodeType;
import net.sf.mmm.util.exception.api.ObjectMismatchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCodeLanguage
implements CodeLanguage {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCodeLanguage.class);

    @Override
    public String verifyName(CodeItemWithName item, String name) {
        Pattern pattern = this.getNamePattern(item);
        return this.verifyName(item, pattern, name);
    }

    @Override
    public String verifySimpleName(CodeItemWithQualifiedName item, String simpleName) {
        Pattern pattern;
        if (item instanceof CodePackage) {
            CodePackage parentPackage = ((CodePackage)item).getParentPackage();
            if (parentPackage == null) {
                if (!"".equals(simpleName)) {
                    throw new IllegalArgumentException("Root package name must be empty. It can not be '" + simpleName + "'.");
                }
                return simpleName;
            }
            pattern = this.getSimpleNamePatternForPackage();
        } else if (item instanceof CodeFile) {
            pattern = this.getSimpleNamePatternForType();
        } else if (item instanceof CodeType) {
            pattern = this.getSimpleNamePatternForType();
        } else {
            LOG.debug("Unexepcted item type: {}", (Object)item);
            return simpleName;
        }
        return this.verifyName(item, pattern, simpleName);
    }

    protected String verifyName(CodeItem item, Pattern pattern, String name) {
        boolean valid = false;
        if (name != null) {
            if (!this.isTypeInDefaultPackage(item) && this.isRevervedKeyword(name, item)) {
                throw new ObjectMismatchException((Object)name, (Object)"no reserved keyword", (Object)item.getClass().getSimpleName(), (Object)"name");
            }
            if (pattern != null) {
                valid = pattern.matcher(name).matches();
            }
        }
        if (!valid) {
            throw new ObjectMismatchException((Object)name, (Object)pattern, (Object)item.getClass().getSimpleName(), (Object)"name");
        }
        return name;
    }

    private boolean isTypeInDefaultPackage(CodeItem item) {
        if (item instanceof CodeFile) {
            return ((CodeFile)item).getParentPackage().isRoot();
        }
        return false;
    }

    protected abstract Pattern getSimpleNamePatternForPackage();

    protected abstract Pattern getSimpleNamePatternForType();

    protected abstract Pattern getNamePattern(CodeItemWithName var1);

    protected abstract boolean isRevervedKeyword(String var1, CodeItem var2);
}

