/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.code.api.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.mmm.code.api.CodeFile;
import net.sf.mmm.code.api.CodePackage;
import net.sf.mmm.code.api.expression.CodeVariable;
import net.sf.mmm.code.api.item.CodeItem;
import net.sf.mmm.code.api.item.CodeItemWithName;
import net.sf.mmm.code.api.language.AbstractCodeLanguage;
import net.sf.mmm.code.api.statement.CodeLocalVariable;
import net.sf.mmm.code.api.type.CodeTypeCategory;

public class JavaLanguage
extends AbstractCodeLanguage {
    public static final String LANGUAGE_NAME_JAVA = "Java";
    public static final String TYPE_EXTENSION_JAVA = ".java";
    public static final String PACKAGE_INFO_JAVA = "package-info.java";
    static final Pattern NAME_PATTERN = Pattern.compile("[\\$_\\w]+");
    static final Pattern NAME_PATTERN_PACKAGE = Pattern.compile("(\\pL|[$_])(\\pL|\\p{Nd}|[$_])*");
    static final Pattern NAME_PATTERN_TYPE = NAME_PATTERN;
    private static final Set<String> REVERVED_NAMES = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));
    private static final JavaLanguage INSTANCE = new JavaLanguage();

    @Override
    public String getLanguageName() {
        return LANGUAGE_NAME_JAVA;
    }

    @Override
    public String getVariableNameThis() {
        return "this";
    }

    @Override
    public String getKeywordForVariable(CodeLocalVariable variable) {
        String keyword = "";
        if (variable.isFinal()) {
            keyword = "final ";
        }
        if (variable.getType() == null) {
            keyword = keyword + "var ";
        }
        return keyword;
    }

    @Override
    public void writeDeclaration(CodeVariable variable, Appendable sink) throws IOException {
        variable.writeReference(sink, false);
        sink.append(' ');
        sink.append(variable.getName());
    }

    @Override
    public String getKeywordForCategory(CodeTypeCategory category) {
        if (category.isAnnotation()) {
            return "@interface";
        }
        if (category.isEnumeration()) {
            return "enum";
        }
        return category.toString();
    }

    @Override
    public String getStatementTerminator() {
        return ";";
    }

    @Override
    protected Pattern getNamePattern(CodeItemWithName item) {
        return NAME_PATTERN;
    }

    @Override
    protected Pattern getSimpleNamePatternForPackage() {
        return NAME_PATTERN_PACKAGE;
    }

    @Override
    protected Pattern getSimpleNamePatternForType() {
        return NAME_PATTERN_TYPE;
    }

    @Override
    protected boolean isRevervedKeyword(String name, CodeItem item) {
        return REVERVED_NAMES.contains(name);
    }

    @Override
    public String getPackageFilename(CodePackage pkg) {
        return PACKAGE_INFO_JAVA;
    }

    @Override
    public String getFileFilename(CodeFile file) {
        return file.getSimpleName() + TYPE_EXTENSION_JAVA;
    }

    public static JavaLanguage get() {
        return INSTANCE;
    }
}

