/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.code.api.modifier;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.sf.mmm.code.api.modifier.CodeVisibility;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.io.api.RuntimeIoException;

public class CodeModifiers {
    public static final String KEY_STATIC = "static";
    public static final String KEY_FINAL = "final";
    public static final String KEY_ABSTRACT = "abstract";
    public static final String KEY_VOLATILE = "volatile";
    public static final String KEY_TRANSIENT = "transient";
    public static final String KEY_NATIVE = "native";
    public static final String KEY_SYNCHRONIZED = "synchronized";
    private static final String KEY_STRICTFP = "strictfp";
    public static final String KEY_DEFAULT = "default";
    public static final CodeModifiers MODIFIERS_PUBLIC = new CodeModifiers(CodeVisibility.PUBLIC, new String[0]);
    public static final CodeModifiers MODIFIERS_PUBLIC_ABSTRACT = new CodeModifiers(CodeVisibility.PUBLIC, "abstract");
    public static final CodeModifiers MODIFIERS_PUBLIC_STATIC = new CodeModifiers(CodeVisibility.PUBLIC, "static");
    public static final CodeModifiers MODIFIERS_PUBLIC_STATIC_FINAL = new CodeModifiers(CodeVisibility.PUBLIC, "static", "final");
    public static final CodeModifiers MODIFIERS_PUBLIC_FINAL = new CodeModifiers(CodeVisibility.PUBLIC, "final");
    public static final CodeModifiers MODIFIERS_PRIVATE = new CodeModifiers(CodeVisibility.PRIVATE, new String[0]);
    public static final CodeModifiers MODIFIERS_PRIVATE_ABSTRACT = new CodeModifiers(CodeVisibility.PRIVATE, "abstract");
    public static final CodeModifiers MODIFIERS_PRIVATE_STATIC = new CodeModifiers(CodeVisibility.PRIVATE, "static");
    public static final CodeModifiers MODIFIERS_PRIVATE_STATIC_FINAL = new CodeModifiers(CodeVisibility.PRIVATE, "static", "final");
    public static final CodeModifiers MODIFIERS_PRIVATE_FINAL = new CodeModifiers(CodeVisibility.PRIVATE, "final");
    public static final CodeModifiers MODIFIERS_PROTECTED = new CodeModifiers(CodeVisibility.PROTECTED, new String[0]);
    public static final CodeModifiers MODIFIERS_PROTECTED_ABSTRACT = new CodeModifiers(CodeVisibility.PROTECTED, "abstract");
    public static final CodeModifiers MODIFIERS_PROTECTED_STATIC = new CodeModifiers(CodeVisibility.PROTECTED, "static");
    public static final CodeModifiers MODIFIERS_PROTECTED_STATIC_FINAL = new CodeModifiers(CodeVisibility.PROTECTED, "static", "final");
    public static final CodeModifiers MODIFIERS_PROTECTED_FINAL = new CodeModifiers(CodeVisibility.PROTECTED, "final");
    public static final CodeModifiers MODIFIERS = new CodeModifiers(CodeVisibility.DEFAULT, new String[0]);
    public static final CodeModifiers MODIFIERS_STATIC = new CodeModifiers(CodeVisibility.DEFAULT, "static");
    public static final CodeModifiers MODIFIERS_STATIC_FINAL = new CodeModifiers(CodeVisibility.DEFAULT, "static", "final");
    public static final CodeModifiers MODIFIERS_FINAL = new CodeModifiers(CodeVisibility.DEFAULT, "final");
    public static final CodeModifiers MODIFIERS_PUBLIC_DEFAULT = new CodeModifiers(CodeVisibility.PUBLIC, "default");
    private final CodeVisibility visibility;
    private final Set<String> modifiers;

    public CodeModifiers(CodeVisibility visibility, String ... modifiers) {
        this(visibility, Arrays.asList(modifiers));
    }

    public CodeModifiers(CodeVisibility visibility, Collection<String> modifiers) {
        Objects.requireNonNull(visibility, "visibility");
        this.visibility = visibility;
        HashSet<String> set = new HashSet<String>(modifiers);
        for (String modifier : set) {
            CodeModifiers.verifyModifier(modifier);
        }
        this.modifiers = Collections.unmodifiableSet(set);
    }

    private static void verifyModifier(String modifier) {
        Objects.requireNonNull(modifier, "modifier");
        if (modifier.isEmpty()) {
            throw new IllegalArgumentException(modifier);
        }
        if (CodeVisibility.of(modifier) != null) {
            throw new IllegalArgumentException(modifier);
        }
    }

    public CodeVisibility getVisibility() {
        return this.visibility;
    }

    public Set<String> getModifiers() {
        return this.modifiers;
    }

    public CodeModifiers addModifier(String modifier) {
        CodeModifiers.verifyModifier(modifier);
        if (this.modifiers.contains(modifier)) {
            return this;
        }
        HashSet<String> newModifiers = new HashSet<String>(this.modifiers);
        newModifiers.add(modifier);
        return new CodeModifiers(this.visibility, newModifiers);
    }

    public CodeModifiers removeModifier(String modifier) {
        CodeModifiers.verifyModifier(modifier);
        if (!this.modifiers.contains(modifier)) {
            return this;
        }
        HashSet<String> newModifiers = new HashSet<String>(this.modifiers);
        newModifiers.remove(modifier);
        return new CodeModifiers(this.visibility, newModifiers);
    }

    public CodeModifiers changeVisibility(CodeVisibility newVisibility) {
        if (this.visibility.equals(newVisibility)) {
            return this;
        }
        return new CodeModifiers(newVisibility, this.modifiers);
    }

    public boolean isAbstract() {
        return this.modifiers.contains(KEY_ABSTRACT);
    }

    public boolean isStatic() {
        return this.modifiers.contains(KEY_STATIC);
    }

    public boolean isFinal() {
        return this.modifiers.contains(KEY_FINAL);
    }

    public boolean isDefaultModifier() {
        return this.modifiers.contains(KEY_DEFAULT);
    }

    public boolean isDefaultVisibility() {
        return CodeVisibility.DEFAULT.equals(this.visibility);
    }

    public boolean isPublic() {
        return CodeVisibility.PUBLIC.equals(this.visibility);
    }

    public boolean isPrivate() {
        return CodeVisibility.PRIVATE.equals(this.visibility);
    }

    public boolean isProtected() {
        return CodeVisibility.PROTECTED.equals(this.visibility);
    }

    public int hashCode() {
        return Objects.hashCode(this.modifiers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CodeModifiers other = (CodeModifiers)obj;
        return Objects.equals(this.modifiers, other.modifiers);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(32);
        String visibilityString = this.visibility.toString();
        if (!visibilityString.isEmpty()) {
            buffer.append(visibilityString);
            buffer.append(' ');
        }
        this.formatModifiers(buffer);
        return buffer.toString();
    }

    public void formatModifiers(Appendable buffer) {
        try {
            if (this.isDefaultModifier()) {
                CodeModifiers.appendModifier(buffer, KEY_DEFAULT);
            }
            if (this.isAbstract()) {
                CodeModifiers.appendModifier(buffer, KEY_ABSTRACT);
            }
            if (this.isStatic()) {
                CodeModifiers.appendModifier(buffer, KEY_STATIC);
            }
            if (this.isFinal()) {
                CodeModifiers.appendModifier(buffer, KEY_FINAL);
            }
            for (String modifier : this.modifiers) {
                if (KEY_DEFAULT.equals(modifier) || KEY_ABSTRACT.equals(modifier) || KEY_STATIC.equals(modifier) || KEY_FINAL.equals(modifier)) continue;
                CodeModifiers.appendModifier(buffer, modifier);
            }
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.WRITE);
        }
    }

    private static void appendModifier(Appendable buffer, String modifier) throws IOException {
        buffer.append(modifier);
        buffer.append(' ');
    }

    public static CodeModifiers of(int javaModifiers) {
        return CodeModifiers.of(javaModifiers, false);
    }

    public static CodeModifiers of(int javaModifiers, boolean defaultMethod) {
        ArrayList<String> modifiers = new ArrayList<String>();
        if (Modifier.isAbstract(javaModifiers)) {
            modifiers.add(KEY_ABSTRACT);
        }
        if (Modifier.isStatic(javaModifiers)) {
            modifiers.add(KEY_STATIC);
        }
        if (Modifier.isFinal(javaModifiers)) {
            modifiers.add(KEY_FINAL);
        }
        if (Modifier.isNative(javaModifiers)) {
            modifiers.add(KEY_NATIVE);
        }
        if (Modifier.isSynchronized(javaModifiers)) {
            modifiers.add(KEY_SYNCHRONIZED);
        }
        if (Modifier.isTransient(javaModifiers)) {
            modifiers.add(KEY_TRANSIENT);
        }
        if (Modifier.isVolatile(javaModifiers)) {
            modifiers.add(KEY_VOLATILE);
        }
        if (Modifier.isStrict(javaModifiers)) {
            modifiers.add(KEY_STRICTFP);
        }
        String[] modifierArray = modifiers.toArray(new String[modifiers.size()]);
        return new CodeModifiers(CodeVisibility.of(javaModifiers), modifierArray);
    }
}

