/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.code.api.type;

import net.sf.mmm.code.api.CodeFile;
import net.sf.mmm.code.api.block.CodeBlockInitializer;
import net.sf.mmm.code.api.copy.CodeNodeItemCopyable;
import net.sf.mmm.code.api.element.CodeElement;
import net.sf.mmm.code.api.element.CodeElementWithModifiers;
import net.sf.mmm.code.api.element.CodeElementWithTypeVariables;
import net.sf.mmm.code.api.item.CodeMutableItemWithQualifiedName;
import net.sf.mmm.code.api.member.CodeConstructors;
import net.sf.mmm.code.api.member.CodeField;
import net.sf.mmm.code.api.member.CodeFields;
import net.sf.mmm.code.api.member.CodeMethods;
import net.sf.mmm.code.api.member.CodeProperties;
import net.sf.mmm.code.api.merge.CodeAdvancedMergeableItem;
import net.sf.mmm.code.api.modifier.CodeModifiers;
import net.sf.mmm.code.api.type.CodeGenericType;
import net.sf.mmm.code.api.type.CodeNestedTypes;
import net.sf.mmm.code.api.type.CodeParameterizedType;
import net.sf.mmm.code.api.type.CodeSuperTypes;
import net.sf.mmm.code.api.type.CodeTypeCategory;
import net.sf.mmm.code.api.type.CodeTypeVariable;

public interface CodeType
extends CodeGenericType,
CodeElementWithModifiers,
CodeMutableItemWithQualifiedName,
CodeElementWithTypeVariables,
CodeAdvancedMergeableItem<CodeType>,
CodeNodeItemCopyable<CodeElement, CodeType> {
    @Override
    public CodeElement getParent();

    public CodeFile getFile();

    @Override
    public CodeTypeCategory getCategory();

    public void setCategory(CodeTypeCategory var1);

    public CodeSuperTypes getSuperTypes();

    public CodeFields getFields();

    public CodeMethods getMethods();

    public CodeConstructors getConstructors();

    public CodeProperties getProperties();

    @Override
    public CodeType getDeclaringType();

    default public boolean isNested() {
        return this.getDeclaringType() != this;
    }

    public CodeNestedTypes getNestedTypes();

    public CodeBlockInitializer getStaticInitializer();

    public void setStaticInitializer(CodeBlockInitializer var1);

    public CodeBlockInitializer getNonStaticInitializer();

    public void setNonStaticInitializer(CodeBlockInitializer var1);

    public boolean isPrimitive();

    public CodeType getNonPrimitiveType();

    public boolean isVoid();

    public boolean isBoolean();

    public boolean isException();

    @Override
    default public boolean isArray() {
        return false;
    }

    @Override
    default public boolean isQualified() {
        return false;
    }

    @Override
    default public CodeTypeVariable asTypeVariable() {
        return null;
    }

    @Override
    default public CodeType asType() {
        return this;
    }

    public CodeParameterizedType createParameterizedType(CodeElement var1);

    public CodeGenericType getQualifiedType();

    @Override
    public Class<?> getReflectiveObject();

    @Override
    default public CodeType resolve(CodeGenericType context) {
        return this;
    }

    @Override
    public CodeType copy();

    default public void createGetters() {
        for (CodeField field : this.getFields().getDeclared()) {
            if (field.getModifiers().isStatic()) continue;
            field.getOrCreateGetter();
        }
    }

    default public void createSetters() {
        for (CodeField field : this.getFields().getDeclared()) {
            CodeModifiers modifiers = field.getModifiers();
            if (modifiers.isStatic() || modifiers.isFinal()) continue;
            field.getOrCreateSetter();
        }
    }

    default public void createGettersAndSetters() {
        for (CodeField field : this.getFields().getDeclared()) {
            CodeModifiers modifiers = field.getModifiers();
            if (modifiers.isStatic()) continue;
            field.getOrCreateGetter();
            if (modifiers.isFinal()) continue;
            field.getOrCreateSetter();
        }
    }
}

