/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.collection.base;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<E>
implements Enumeration<E>,
Iterator<E> {
    private final E[] array;
    private final int stopIndex;
    private int index;

    public ArrayIterator(E[] array) {
        this(array, 0, array == null ? 0 : array.length - 1);
    }

    public ArrayIterator(E[] array, int start, int end) {
        int max;
        if (array == null) {
            this.array = null;
            this.index = 0;
            this.stopIndex = 0;
            max = 0;
        } else {
            this.array = array;
            this.index = start;
            this.stopIndex = end + 1;
            max = array.length - 1;
        }
        if (start > 0 || end > -1) {
            if (start > end) {
                throw new IllegalArgumentException("Start (" + start + ") must not exceed end (" + end + ").");
            }
            if (end < max) {
                throw new IllegalArgumentException("End (" + start + ") must not exceed max (" + max + ").");
            }
        }
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasNext();
    }

    @Override
    public boolean hasNext() {
        return this.index < this.stopIndex;
    }

    @Override
    public E nextElement() {
        return this.next();
    }

    @Override
    public E next() {
        if (this.index >= this.stopIndex) {
            throw new NoSuchElementException(Integer.toString(this.index));
        }
        return this.array[this.index++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

