/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.collection.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.TransferQueue;
import net.sf.mmm.util.collection.api.CollectionFactory;
import net.sf.mmm.util.collection.api.CollectionFactoryManager;
import net.sf.mmm.util.collection.api.MapFactory;
import net.sf.mmm.util.collection.base.ArrayListFactory;
import net.sf.mmm.util.collection.base.ConcurrentHashMapFactory;
import net.sf.mmm.util.collection.base.ConcurrentSkipListMapFactory;
import net.sf.mmm.util.collection.base.HashMapFactory;
import net.sf.mmm.util.collection.base.HashSetFactory;
import net.sf.mmm.util.collection.base.LinkedBlockingQueueFactory;
import net.sf.mmm.util.collection.base.LinkedListDequeFactory;
import net.sf.mmm.util.collection.base.LinkedListQueueFactory;
import net.sf.mmm.util.collection.base.NavigableTreeMapFactory;
import net.sf.mmm.util.collection.base.NavigableTreeSetFactory;
import net.sf.mmm.util.collection.base.TreeSetFactory;
import net.sf.mmm.util.collection.impl.UnknownCollectionInterfaceException;
import net.sf.mmm.util.component.base.AbstractComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionFactoryManagerImpl
extends AbstractComponent
implements CollectionFactoryManager {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionFactoryManagerImpl.class);
    private static final Class<?>[] CAPACITY_CONSTRUCTOR_ARGS = new Class[]{Integer.TYPE};
    private static CollectionFactoryManager instance;
    private final Map<Class<? extends Collection>, CollectionFactory> collectionFactoryMap;
    private final Map<Class<? extends Map>, MapFactory> mapFactoryMap = new HashMap<Class<? extends Map>, MapFactory>();

    public CollectionFactoryManagerImpl() {
        this.collectionFactoryMap = new HashMap<Class<? extends Collection>, CollectionFactory>();
    }

    protected void doInitialize() {
        super.doInitialize();
        this.registerCollectionFactory(ArrayListFactory.INSTANCE, Collection.class);
        this.registerCollectionFactory(ArrayListFactory.INSTANCE);
        this.registerCollectionFactory(HashSetFactory.INSTANCE);
        this.registerCollectionFactory(TreeSetFactory.INSTANCE);
        this.registerCollectionFactory(LinkedListQueueFactory.INSTANCE);
        this.registerCollectionFactory(LinkedBlockingQueueFactory.INSTANCE);
        this.registerCollectionFactory(LinkedListDequeFactory.INSTANCE);
        this.registerCollectionFactory(NavigableTreeSetFactory.INSTANCE);
        this.registerMapFactory(HashMapFactory.INSTANCE);
        this.registerMapFactory(ConcurrentHashMapFactory.INSTANCE);
        this.registerMapFactory(NavigableTreeMapFactory.INSTANCE);
        this.registerMapFactory(ConcurrentSkipListMapFactory.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CollectionFactoryManager getInstance() {
        if (instance != null) return instance;
        Class<CollectionFactoryManagerImpl> clazz = CollectionFactoryManagerImpl.class;
        synchronized (CollectionFactoryManagerImpl.class) {
            if (instance != null) return instance;
            CollectionFactoryManagerImpl manager = new CollectionFactoryManagerImpl();
            manager.initialize();
            instance = manager;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public <C extends Collection> CollectionFactory<C> getCollectionFactory(Class<C> collectionType) {
        return this.collectionFactoryMap.get(collectionType);
    }

    @Override
    public <MAP extends Map> MapFactory getMapFactory(Class<MAP> mapType) {
        return this.mapFactoryMap.get(mapType);
    }

    protected MapFactory registerMapFactory(MapFactory factory) {
        return this.registerMapFactory(factory, factory.getMapInterface());
    }

    protected <MAP extends Map> MapFactory registerMapFactory(MapFactory<? extends MAP> factory, Class<MAP> mapInterface) {
        return this.mapFactoryMap.put(mapInterface, factory);
    }

    protected CollectionFactory registerCollectionFactory(CollectionFactory factory) {
        return this.registerCollectionFactory(factory, factory.getCollectionInterface());
    }

    protected <COLLECTION extends Collection> CollectionFactory registerCollectionFactory(CollectionFactory<? extends COLLECTION> factory, Class<COLLECTION> collectionInterface) {
        if (!collectionInterface.isAssignableFrom(factory.getCollectionInterface())) {
            throw new IllegalArgumentException();
        }
        return this.collectionFactoryMap.put(collectionInterface, factory);
    }

    @Override
    public <C extends Collection> C create(Class<C> type) {
        return this.create(type, null);
    }

    @Override
    public <C extends Collection> C create(Class<C> type, int capacity) {
        return this.create(type, (Integer)capacity);
    }

    protected <C extends Collection<?>> C create(Class<C> type, Integer capacity) {
        Class<? extends Collection> collectionInterface;
        if (type.isInterface()) {
            CollectionFactory<C> factory = this.getCollectionFactory(type);
            if (factory == null) {
                throw new UnknownCollectionInterfaceException(type);
            }
            if (capacity == null) {
                return factory.createGeneric();
            }
            return factory.createGeneric(capacity);
        }
        if (Modifier.isAbstract(type.getModifiers()) && (collectionInterface = this.findCollectionInterface(type)) != Collection.class) {
            return (C)this.create((Class<C>)collectionInterface, capacity);
        }
        try {
            if (capacity != null) {
                try {
                    Constructor<C> constructor = type.getConstructor(CAPACITY_CONSTRUCTOR_ARGS);
                    return (C)((Collection)constructor.newInstance(capacity));
                }
                catch (Exception e) {
                    LOG.debug("Failed to create collection via capacitory constructor.", (Throwable)e);
                }
            }
            return (C)((Collection)type.newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create collection of type: " + type, e);
        }
    }

    protected Class<? extends Collection> findCollectionInterface(Class<? extends Collection> type) {
        if (type.isInterface()) {
            return type;
        }
        if (List.class.isAssignableFrom(type)) {
            return List.class;
        }
        if (Queue.class.isAssignableFrom(type)) {
            if (BlockingDeque.class.isAssignableFrom(type)) {
                return BlockingDeque.class;
            }
            if (Deque.class.isAssignableFrom(type)) {
                return Deque.class;
            }
            if (BlockingQueue.class.isAssignableFrom(type)) {
                return BlockingQueue.class;
            }
            if (TransferQueue.class.isAssignableFrom(type)) {
                return TransferQueue.class;
            }
            return Queue.class;
        }
        if (Set.class.isAssignableFrom(type)) {
            if (NavigableSet.class.isAssignableFrom(type)) {
                return NavigableSet.class;
            }
            if (SortedSet.class.isAssignableFrom(type)) {
                return SortedSet.class;
            }
            return Set.class;
        }
        return Collection.class;
    }

    @Override
    public <C extends Map> C createMap(Class<C> type) {
        return this.createMap(type, null);
    }

    @Override
    public <C extends Map> C createMap(Class<C> type, int capacity) {
        return this.createMap(type, (Integer)capacity);
    }

    protected <C extends Map<?, ?>> C createMap(Class<C> type, Integer capacity) {
        if (type.isInterface()) {
            MapFactory factory = this.getMapFactory(type);
            if (factory == null) {
                throw new UnknownCollectionInterfaceException(type);
            }
            if (capacity == null) {
                return (C)factory.createGeneric();
            }
            return (C)factory.createGeneric(capacity);
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            Class<? extends Map> collectionInterface = this.findMapInterface(type);
            return (C)this.createMap((Class<C>)collectionInterface, capacity);
        }
        try {
            if (capacity != null) {
                try {
                    Constructor<C> constructor = type.getConstructor(CAPACITY_CONSTRUCTOR_ARGS);
                    return (C)((Map)constructor.newInstance(capacity));
                }
                catch (Exception e) {
                    LOG.debug("Failed to create map via capacitory constructor.", (Throwable)e);
                }
            }
            return (C)((Map)type.newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create collection of type: " + type, e);
        }
    }

    protected Class<? extends Map> findMapInterface(Class<? extends Map> type) {
        if (type.isInterface()) {
            return type;
        }
        if (ConcurrentNavigableMap.class.isAssignableFrom(type)) {
            return ConcurrentNavigableMap.class;
        }
        if (NavigableMap.class.isAssignableFrom(type)) {
            return NavigableMap.class;
        }
        if (ConcurrentMap.class.isAssignableFrom(type)) {
            return ConcurrentMap.class;
        }
        return Map.class;
    }
}

