/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.file.base;

import net.sf.mmm.util.file.api.FileAccessClass;
import net.sf.mmm.util.filter.api.CharFilter;
import net.sf.mmm.util.scanner.base.CharSequenceScanner;

public class FileAccessPermissions
implements Cloneable {
    private static final int MASK_MAX = 4095;
    private static final int MASK_USER = 64;
    private static final int MASK_GROUP = 8;
    private static final int MASK_OTHERS = 1;
    private static final int MASK_ALL = 73;
    public static final int MASK_READABLE = 4;
    public static final int MASK_WRITABLE = 2;
    public static final int MASK_EXECUTABLE = 1;
    public static final int MASK_SETUID = 2048;
    public static final int MASK_SETGID = 1024;
    public static final int MASK_STICKY = 512;
    private static final int MASK_USER_FLAGS = 448;
    private static final int MASK_GROUP_FLAGS = 56;
    private static final int MASK_OTHERS_FLAGS = 7;
    private static final int MASK_FULL_FILE_ACCESS = 438;
    private static final int MASK_FULL_DIRECTORY_ACCESS = 511;
    private static final int MASK_ALL_EXECUTABLE = 73;
    private static final int MASK_ALL_WRITABLE = 146;
    private static final int MASK_ALL_READABLE = 292;
    private int maskBits;

    public FileAccessPermissions() {
    }

    public FileAccessPermissions(int mask) {
        this.setMaskBits(mask);
    }

    public static FileAccessPermissions createByUmask(int umask, boolean isDirectory) {
        int fullAccessMask = isDirectory ? 511 : 438;
        int mask = fullAccessMask & ~umask;
        return new FileAccessPermissions(mask);
    }

    public int getMaskBits() {
        return this.maskBits;
    }

    public void setMaskBits(int mask) throws IllegalArgumentException {
        if (mask > 4095 || mask < 0) {
            throw new IllegalArgumentException("File mode mask out of range: " + mask);
        }
        this.maskBits = mask;
    }

    public boolean isReadable(FileAccessClass fileModeClass) {
        return this.hasFlag(fileModeClass, 4);
    }

    public void setReadable(boolean readable) {
        this.setBits(292, readable);
    }

    public void setReadable(FileAccessClass fileModeClass, boolean readable) {
        this.setFlag(fileModeClass, 4, readable);
    }

    public boolean isWritable(FileAccessClass fileModeClass) {
        return this.hasFlag(fileModeClass, 2);
    }

    public void setWritable(boolean writable) {
        this.setBits(146, writable);
    }

    public void setWritable(FileAccessClass fileModeClass, boolean writable) {
        this.setFlag(fileModeClass, 2, writable);
    }

    public boolean isExecutable(FileAccessClass fileModeClass) {
        return this.hasFlag(fileModeClass, 1);
    }

    public void setExecutable(boolean executable) {
        this.setBits(73, executable);
    }

    public void setExecutable(FileAccessClass fileModeClass, boolean executable) {
        this.setFlag(fileModeClass, 1, executable);
    }

    public boolean isSetuid() {
        return this.hasBits(2048);
    }

    public void setSetuid(boolean setuid) {
        this.setBits(2048, setuid);
    }

    public boolean isSetgid() {
        return this.hasBits(1024);
    }

    public void setSetgid(boolean setgid) {
        this.setBits(1024, setgid);
    }

    public boolean isSticky() {
        return this.hasBits(512);
    }

    public void setSticky(boolean sticky) {
        this.setBits(512, sticky);
    }

    private int shiftMask(FileAccessClass fileModeClass, int bitMask) {
        if (fileModeClass == FileAccessClass.USER) {
            return bitMask << 6;
        }
        if (fileModeClass == FileAccessClass.GROUP) {
            return bitMask << 3;
        }
        if (fileModeClass == FileAccessClass.OTHERS) {
            return bitMask;
        }
        throw new IllegalArgumentException("Illegal FileModeClass: " + (Object)((Object)fileModeClass));
    }

    private void setFlag(FileAccessClass fileModeClass, int bitMask, boolean flag) {
        this.setBits(this.shiftMask(fileModeClass, bitMask), flag);
    }

    private boolean hasFlag(FileAccessClass fileModeClass, int bitMask) {
        return this.hasBits(this.shiftMask(fileModeClass, bitMask));
    }

    private boolean hasBits(int bitMask) {
        return (this.maskBits & bitMask) == bitMask;
    }

    private void setBits(int bitMask, boolean set) {
        this.maskBits = set ? (this.maskBits |= bitMask) : (this.maskBits &= ~bitMask);
    }

    private static int parseUGO(CharSequenceScanner parse) {
        char c;
        int ugo = 0;
        while (true) {
            if ((c = parse.forceNext()) == 'u') {
                ugo |= 0x40;
                continue;
            }
            if (c == 'g') {
                ugo |= 8;
                continue;
            }
            if (c == 'o') {
                ugo |= 1;
                continue;
            }
            if (c != 'a') break;
            ugo = 73;
        }
        if (ugo == 0) {
            ugo = 73;
        }
        if (c != '\u0000') {
            parse.stepBack();
        }
        return ugo;
    }

    private static int parseSymbolicMode(CharSequenceScanner parse, int maskBits) {
        int mask = maskBits;
        int ugo = FileAccessPermissions.parseUGO(parse);
        char mode = parse.forceNext();
        int flags = 0;
        int template = -1;
        char c = parse.forceNext();
        if (c == 'u') {
            template = (mask & 0x1C0) >> 6;
        } else if (c == 'g') {
            template = (mask & 0x38) >> 3;
        } else if (c == 'o') {
            template = mask & 7;
        } else {
            while (c != '\u0000') {
                if (c == 'r') {
                    flags |= ugo << 2;
                } else if (c == 'w') {
                    flags |= ugo << 1;
                } else if (c == 'x') {
                    flags |= ugo;
                } else if (c == 's') {
                    flags |= 0x800;
                } else if (c == 'S') {
                    flags |= 0x400;
                } else if (c == 't') {
                    flags |= 0x200;
                } else {
                    parse.stepBack();
                    break;
                }
                c = parse.forceNext();
            }
        }
        if (template != -1) {
            if ((ugo & 1) != 0) {
                flags = template;
            }
            if ((ugo & 8) != 0) {
                flags |= template << 3;
            }
            if ((ugo & 0x40) != 0) {
                flags |= template << 6;
            }
        }
        if (mode == '+') {
            mask |= flags;
        } else if (mode == '-') {
            mask &= ~flags;
        } else if (mode == '=') {
            int clear = ugo | ugo << 1 | ugo << 2;
            mask &= ~clear;
            mask |= flags;
        } else {
            throw new IllegalArgumentException("op: '" + mode + "'");
        }
        return mask;
    }

    private static int parseOctalMode(CharSequenceScanner parse) throws IllegalArgumentException {
        String octals = parse.readWhile(CharFilter.LATIN_DIGIT_FILTER);
        if (octals.length() == 0) {
            return -1;
        }
        if (octals.length() > 4) {
            throw new IllegalArgumentException();
        }
        return Integer.parseInt(octals, 8);
    }

    public void chmod(String chmod) {
        CharSequenceScanner parse = new CharSequenceScanner(chmod);
        if (!parse.hasNext()) {
            throw new IllegalArgumentException();
        }
        int mask = this.maskBits;
        try {
            int octal = FileAccessPermissions.parseOctalMode(parse);
            if (octal == -1) {
                while (parse.hasNext()) {
                    mask = FileAccessPermissions.parseSymbolicMode(parse, mask);
                    char c = parse.forceNext();
                    if (c == ',' || c == '\u0000') continue;
                    throw new IllegalArgumentException("'" + c + "'");
                }
            } else {
                mask = octal;
                char c = parse.forceNext();
                if (c != '\u0000') {
                    throw new IllegalArgumentException("'" + c + "'");
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Illegal chmod: " + chmod, e);
        }
        this.maskBits = mask;
    }

    public int hashCode() {
        return this.maskBits;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        FileAccessPermissions otherMask = (FileAccessPermissions)obj;
        return this.maskBits == otherMask.maskBits;
    }

    public FileAccessPermissions clone() {
        try {
            return (FileAccessPermissions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        String result = Integer.toString(this.maskBits, 8);
        int len = result.length();
        if (len == 1) {
            result = "000" + result;
        } else if (len == 2) {
            result = "00" + result;
        } else if (len == 3) {
            result = "0" + result;
        }
        return result;
    }
}

