/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.file.base;

import net.sf.mmm.util.file.base.FileAccessPermissions;
import net.sf.mmm.util.lang.api.BasicUtil;
import net.sf.mmm.util.lang.base.BasicUtilImpl;

public class FileAttributes
implements Cloneable {
    private String user;
    private String group;
    private FileAccessPermissions permissions;
    private BasicUtil basicUtil;

    public FileAttributes() {
        this.basicUtil = BasicUtilImpl.getInstance();
    }

    public FileAttributes(BasicUtil basicUtil) {
        this.basicUtil = basicUtil;
    }

    public FileAttributes clone() {
        try {
            FileAttributes clone = (FileAttributes)super.clone();
            if (clone.permissions != null) {
                clone.setPermissions(clone.permissions.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public FileAccessPermissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(FileAccessPermissions mask) {
        this.permissions = mask;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileAttributes otherAttributes = (FileAttributes)obj;
        if (!this.basicUtil.isEqual((Object)this.user, (Object)otherAttributes.user)) {
            return false;
        }
        if (!this.basicUtil.isEqual((Object)this.group, (Object)otherAttributes.group)) {
            return false;
        }
        return this.basicUtil.isEqual((Object)this.permissions, (Object)otherAttributes.permissions);
    }

    public int hashCode() {
        int hash = 0;
        if (this.user != null) {
            hash = this.user.hashCode();
        }
        if (this.group != null) {
            hash = hash * 31 + this.group.hashCode();
        }
        if (this.permissions != null) {
            hash = hash * 31 + this.permissions.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.user != null) {
            sb.append(this.user);
        }
        sb.append(':');
        if (this.group != null) {
            sb.append(this.group);
        }
        sb.append(' ');
        if (this.permissions != null) {
            sb.append(this.permissions);
        }
        return super.toString();
    }
}

