/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.file.base;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.sf.mmm.util.component.api.AlreadyInitializedException;
import net.sf.mmm.util.file.api.FileAccessClass;
import net.sf.mmm.util.file.api.FileAlreadyExistsException;
import net.sf.mmm.util.file.api.FileAttributeModificationFailedException;
import net.sf.mmm.util.file.api.FileCreationFailedException;
import net.sf.mmm.util.file.api.FileDeletionFailedException;
import net.sf.mmm.util.file.api.FilePermissionException;
import net.sf.mmm.util.file.api.FileType;
import net.sf.mmm.util.file.api.FileUtil;
import net.sf.mmm.util.file.base.DirectoryFilter;
import net.sf.mmm.util.file.base.FileAccessPermissions;
import net.sf.mmm.util.file.base.FileUtilLimitedImpl;
import net.sf.mmm.util.file.base.PatternFileFilter;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.io.api.RuntimeIoException;
import net.sf.mmm.util.lang.api.StringUtil;
import net.sf.mmm.util.lang.base.StringUtilImpl;
import net.sf.mmm.util.resource.api.ResourcePathNode;

public class FileUtilImpl
extends FileUtilLimitedImpl
implements FileUtil {
    private static FileUtil instance;
    private StringUtil stringUtil;
    private String userHomeDirectoryPath;
    private File userHomeDirectory;
    private String userLogin;
    private String temporaryDirectoryPath;
    private File temporaryDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileUtil getInstance() {
        if (instance != null) return instance;
        Class<FileUtilImpl> clazz = FileUtilImpl.class;
        synchronized (FileUtilImpl.class) {
            if (instance != null) return instance;
            FileUtilImpl util = new FileUtilImpl();
            util.initialize();
            instance = util;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.stringUtil == null) {
            this.stringUtil = StringUtilImpl.getInstance();
        }
        if (this.temporaryDirectoryPath == null) {
            this.temporaryDirectoryPath = System.getProperty("java.io.tmpdir");
        }
        this.temporaryDirectoryPath = this.temporaryDirectoryPath.replace('\\', '/');
        if (this.temporaryDirectory == null) {
            this.temporaryDirectory = new File(this.temporaryDirectoryPath);
        }
        if (this.userHomeDirectoryPath == null) {
            this.userHomeDirectoryPath = System.getProperty("user.home");
        }
        this.userHomeDirectoryPath = this.userHomeDirectoryPath.replace('\\', '/');
        if (this.userHomeDirectory == null) {
            this.userHomeDirectory = new File(this.userHomeDirectoryPath);
        }
        if (this.userLogin == null) {
            this.userLogin = System.getProperty("user.name");
        }
    }

    protected StringUtil getStringUtil() {
        return this.stringUtil;
    }

    @Inject
    public void setStringUtil(StringUtil stringUtil) throws AlreadyInitializedException {
        this.getInitializationState().requireNotInitilized();
        this.stringUtil = stringUtil;
    }

    @Override
    public File getUserHomeDirectory() {
        return this.userHomeDirectory;
    }

    protected String getUserHomeDirectoryPath() {
        return this.userHomeDirectoryPath;
    }

    public void setUserHomeDirectoryPath(String userHome) throws AlreadyInitializedException {
        this.getInitializationState().requireNotInitilized();
        this.userHomeDirectoryPath = userHome;
    }

    @Override
    public File getTemporaryDirectory() {
        return this.temporaryDirectory;
    }

    public void setTemporaryDirectoryPath(String tmpDir) throws AlreadyInitializedException {
        this.getInitializationState().requireNotInitilized();
        this.temporaryDirectoryPath = tmpDir;
    }

    public String getUserLogin() {
        return this.userLogin;
    }

    public void setUserLogin(String userLogin) {
        this.getInitializationState().requireNotInitilized();
        this.userLogin = userLogin;
    }

    @Override
    public boolean mkdirs(File directory) {
        if (directory.isDirectory()) {
            return false;
        }
        boolean mkdirs = directory.mkdirs();
        if (!mkdirs && !(mkdirs = directory.mkdirs())) {
            throw new FileCreationFailedException(directory, true);
        }
        return true;
    }

    @Override
    public boolean ensureFileExists(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new FileCreationFailedException(file.getPath(), false);
            }
            return false;
        }
        File parent = file.getParentFile();
        if (parent != null) {
            this.mkdirs(parent);
        }
        boolean created = false;
        try {
            created = file.createNewFile();
        }
        catch (IOException e) {
            throw new FileCreationFailedException(e, file);
        }
        assert (file.isFile());
        return created;
    }

    @Override
    public boolean touch(File file) {
        boolean created = this.ensureFileExists(file);
        if (!file.canWrite()) {
            throw new FilePermissionException(file);
        }
        boolean touched = file.setLastModified(System.currentTimeMillis());
        if (!touched) {
            throw new FileAttributeModificationFailedException(file);
        }
        return created;
    }

    @Override
    public void copyFile(File source, File destination) {
        try (FileInputStream sourceStream = new FileInputStream(source);
             FileOutputStream destinationStream = new FileOutputStream(destination);){
            FileChannel sourceChannel = sourceStream.getChannel();
            sourceChannel.transferTo(0L, sourceChannel.size(), destinationStream.getChannel());
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.COPY);
        }
    }

    @Override
    public void copyFile(File source, File destination, boolean keepFlags) {
        this.copyFile(source, destination);
        if (keepFlags) {
            if (source.canExecute()) {
                destination.setExecutable(true, false);
            }
            boolean success = true;
            if (!source.canWrite()) {
                success = destination.setReadOnly();
            }
            long lastModified = source.lastModified();
            boolean bl = success = success && destination.setLastModified(lastModified);
            if (!success) {
                throw new FileAttributeModificationFailedException(destination);
            }
        }
    }

    @Override
    public void copyRecursive(File source, File destination, boolean allowOverwrite) {
        this.copyRecursive(source, destination, allowOverwrite, null);
    }

    @Override
    public void copyRecursive(File source, File destination, boolean allowOverwrite, FileFilter filter) {
        if (!allowOverwrite && destination.exists()) {
            throw new FileAlreadyExistsException(destination);
        }
        this.copyRecursive(source, destination, filter);
    }

    private void copyRecursive(File source, File destination, FileFilter filter) {
        if (source.isDirectory()) {
            boolean okay = destination.mkdir();
            if (!okay) {
                throw new FileCreationFailedException(destination.getAbsolutePath(), true);
            }
            File[] children = filter == null ? source.listFiles() : source.listFiles(filter);
            for (File file : children) {
                this.copyRecursive(file, new File(destination, file.getName()), filter);
            }
        } else {
            this.copyFile(source, destination);
        }
    }

    @Override
    public FileAccessPermissions getPermissions(File file, FileAccessClass accessClass) {
        FileAccessPermissions permissions = new FileAccessPermissions();
        boolean x = file.canExecute();
        boolean w = file.canWrite();
        boolean r = file.canRead();
        if (accessClass == null) {
            permissions.setExecutable(x);
            permissions.setWritable(w);
            permissions.setReadable(r);
        } else {
            permissions.setExecutable(accessClass, x);
            permissions.setWritable(accessClass, w);
            permissions.setReadable(accessClass, r);
        }
        return permissions;
    }

    @Override
    public void setPermissions(File file, FileAccessPermissions permissions) {
        boolean success = true;
        success &= file.setExecutable(permissions.isExecutable(FileAccessClass.OTHERS));
        success &= file.setWritable(permissions.isWritable(FileAccessClass.OTHERS));
        success &= file.setReadable(permissions.isReadable(FileAccessClass.OTHERS));
        success &= file.setExecutable(permissions.isExecutable(FileAccessClass.USER), true);
        success &= file.setWritable(permissions.isWritable(FileAccessClass.USER), true);
        if (!(success &= file.setReadable(permissions.isReadable(FileAccessClass.USER), true))) {
            throw new FileAttributeModificationFailedException(file);
        }
    }

    @Override
    public boolean delete(File file) throws FileDeletionFailedException {
        if (!file.exists()) {
            return false;
        }
        boolean deleted = file.delete();
        if (deleted) {
            return true;
        }
        deleted = file.delete();
        if (deleted) {
            this.getLogger().debug("Deletion failed and succeeded after retry for file {}", (Object)file);
            return true;
        }
        throw new FileDeletionFailedException(file);
    }

    @Override
    public int deleteRecursive(File path) {
        return this.deleteRecursive(path, null);
    }

    @Override
    public int deleteRecursive(File path, FileFilter filter) throws RuntimeIoException {
        int deleteCount = 0;
        if (path.exists()) {
            if (path.isDirectory()) {
                deleteCount = this.deleteChildren(path, filter);
                if (filter == null) {
                    this.delete(path);
                } else {
                    boolean deleted = path.delete();
                    if (!deleted) {
                        this.getLogger().debug("Directory {} was not deleted.", (Object)path);
                    }
                }
            } else if (filter == null || filter.accept(path)) {
                deleteCount = 1;
                this.delete(path);
            }
        }
        return deleteCount;
    }

    @Override
    public int deleteChildren(File directory) {
        return this.deleteChildren(directory, null);
    }

    @Override
    public int deleteChildren(File directory, FileFilter filter) throws FileDeletionFailedException {
        int deleteCount = 0;
        File[] children = directory.listFiles();
        if (children != null) {
            for (File file : children) {
                if (file.isDirectory()) {
                    deleteCount += this.deleteChildren(file, filter);
                    if (filter == null) {
                        this.delete(file);
                        continue;
                    }
                    boolean deleted = file.delete();
                    if (deleted) continue;
                    this.getLogger().trace("Directory {} was not deleted.", (Object)file);
                    continue;
                }
                if (filter != null && !filter.accept(file)) continue;
                this.delete(file);
                ++deleteCount;
            }
        }
        return deleteCount;
    }

    @Override
    public File[] getMatchingFiles(File cwd, String path, FileType fileType) {
        ArrayList<File> list = new ArrayList<File>();
        this.collectMatchingFiles(cwd, path, fileType, list);
        return list.toArray(new File[list.size()]);
    }

    @Override
    public boolean collectMatchingFiles(File cwd, String path, FileType fileType, Collection<File> list) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        ResourcePathNode patternPath = ResourcePathNode.createPattern((String)path);
        List segments = patternPath.asList();
        this.collectMatchingFiles(cwd, segments, 1, fileType, list);
        boolean hasPattern = false;
        for (ResourcePathNode segment : segments) {
            if (segment.getData() == null) continue;
            hasPattern = true;
            break;
        }
        return hasPattern;
    }

    private void collectMatchingFiles(File cwd, List<ResourcePathNode<Pattern>> segments, int segmentIndex, FileType fileType, Collection<File> list) {
        block9: {
            Pattern pattern;
            ResourcePathNode<Pattern> currentSegment;
            boolean lastSegment;
            block8: {
                File newCwd;
                block10: {
                    lastSegment = segmentIndex + 1 >= segments.size();
                    currentSegment = segments.get(segmentIndex);
                    pattern = (Pattern)currentSegment.getData();
                    if (pattern != null) break block8;
                    newCwd = new File(cwd, currentSegment.getName());
                    if (!newCwd.exists()) break block9;
                    if (!lastSegment) break block10;
                    if (fileType != null && FileType.getType(newCwd) != fileType) break block9;
                    list.add(newCwd);
                    break block9;
                }
                if (!newCwd.isDirectory()) break block9;
                this.collectMatchingFiles(newCwd, segments, segmentIndex + 1, fileType, list);
                break block9;
            }
            if ("**".equals(currentSegment.getName())) {
                File[] children;
                this.collectMatchingFiles(cwd, segments, segmentIndex + 1, fileType, list);
                for (File file : children = cwd.listFiles(DirectoryFilter.getInstance())) {
                    this.collectMatchingFiles(file, segments, segmentIndex, fileType, list);
                }
            } else {
                FileType filterType = fileType;
                if (!lastSegment) {
                    filterType = FileType.DIRECTORY;
                }
                PatternFileFilter filter = new PatternFileFilter(pattern, filterType);
                File[] children = cwd.listFiles(filter);
                if (lastSegment) {
                    for (File file : children) {
                        list.add(file);
                    }
                } else {
                    for (File file : children) {
                        this.collectMatchingFiles(file, segments, segmentIndex + 1, fileType, list);
                    }
                }
            }
        }
    }
}

