/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.file.base;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;
import net.sf.mmm.util.file.api.FileType;
import net.sf.mmm.util.pattern.base.GlobPatternCompiler;

public class PatternFileFilter
implements FileFilter {
    private final Pattern pattern;
    private final FileType fileType;

    public PatternFileFilter(Pattern filenamePattern) {
        this(filenamePattern, null);
    }

    public PatternFileFilter(String filenamePattern, FileType type) {
        this(new GlobPatternCompiler().compile(filenamePattern), type);
    }

    public PatternFileFilter(Pattern filenamePattern, FileType type) {
        this.pattern = filenamePattern;
        this.fileType = type;
    }

    @Override
    public boolean accept(File file) {
        if (this.fileType != null && this.fileType != FileType.getType(file)) {
            return false;
        }
        return this.pattern.matcher(file.getName()).matches();
    }
}

