/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.io.api;

public enum ByteOrderMark {
    UTF_8{

        @Override
        public String getEncoding() {
            return "UTF-8";
        }

        @Override
        public byte[] getBytes() {
            return MAGIC_BYTES_UTF8;
        }
    }
    ,
    UTF_16_BE{

        @Override
        public String getEncoding() {
            return "UTF-16BE";
        }

        @Override
        public byte[] getBytes() {
            return MAGIC_BYTES_UTF16_BE;
        }
    }
    ,
    UTF_16_LE{

        @Override
        public String getEncoding() {
            return "UTF-16LE";
        }

        @Override
        public byte[] getBytes() {
            return MAGIC_BYTES_UTF16_LE;
        }
    }
    ,
    UTF_32_BE{

        @Override
        public String getEncoding() {
            return "UTF-32BE";
        }

        @Override
        public byte[] getBytes() {
            return MAGIC_BYTES_UTF32_BE;
        }
    }
    ,
    UTF_32_LE{

        @Override
        public String getEncoding() {
            return "UTF-32LE";
        }

        @Override
        public byte[] getBytes() {
            return MAGIC_BYTES_UTF32_LE;
        }
    };

    private static final byte[] MAGIC_BYTES_UTF8;
    private static final byte[] MAGIC_BYTES_UTF16_BE;
    private static final byte[] MAGIC_BYTES_UTF16_LE;
    private static final byte[] MAGIC_BYTES_UTF32_BE;
    private static final byte[] MAGIC_BYTES_UTF32_LE;

    public abstract String getEncoding();

    public final int getLength() {
        return this.getBytes().length;
    }

    public final boolean isPresent(byte[] bytes, int offset) {
        byte[] bom = this.getBytes();
        if (offset + bom.length <= bytes.length) {
            for (int i = 0; i < bom.length; ++i) {
                if (bytes[offset + i] == bom[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected abstract byte[] getBytes();

    public static ByteOrderMark detect(byte[] bytes, int offset) {
        for (ByteOrderMark bom : ByteOrderMark.values()) {
            if (!bom.isPresent(bytes, offset)) continue;
            return bom;
        }
        return null;
    }

    static {
        MAGIC_BYTES_UTF8 = new byte[]{-17, -69, -65};
        MAGIC_BYTES_UTF16_BE = new byte[]{-2, -1};
        MAGIC_BYTES_UTF16_LE = new byte[]{-1, -2};
        MAGIC_BYTES_UTF32_BE = new byte[]{0, 0, -2, -1};
        MAGIC_BYTES_UTF32_LE = new byte[]{-1, -2, 0, 0};
    }
}

