/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.io.base;

import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;
import net.sf.mmm.util.io.api.ByteArray;
import net.sf.mmm.util.io.base.ByteArrayImpl;

public abstract class AbstractByteArray
implements ByteArray {
    protected void checkSubArray(int minimum, int maximum) {
        if (minimum < this.getMinimumIndex()) {
            throw new NlsIllegalArgumentException((Object)"minimum");
        }
        if (maximum > this.getMaximumIndex()) {
            throw new NlsIllegalArgumentException((Object)"maximum");
        }
    }

    @Override
    public ByteArray createSubArray(int minimum, int maximum) {
        this.checkSubArray(minimum, maximum);
        return new ByteArrayImpl(this.getBytes(), minimum, maximum);
    }

    @Override
    public int getBytesAvailable() {
        return this.getMaximumIndex() - this.getCurrentIndex() + 1;
    }
}

