/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.io.base;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import net.sf.mmm.util.component.api.AlreadyInitializedException;
import net.sf.mmm.util.component.api.ResourceMissingException;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.io.api.DetectorInputStream;
import net.sf.mmm.util.io.api.DetectorOutputStream;
import net.sf.mmm.util.io.api.DetectorStreamProvider;
import net.sf.mmm.util.io.api.spi.DetectorStreamProcessorFactory;
import net.sf.mmm.util.pool.api.ByteArrayPool;
import net.sf.mmm.util.pool.base.NoByteArrayPool;

public abstract class AbstractDetectorStreamProvider
extends AbstractLoggableComponent
implements DetectorStreamProvider {
    private List<DetectorStreamProcessorFactory> processorFactoryList;
    private ByteArrayPool byteArrayPool;

    public List<DetectorStreamProcessorFactory> getProcessorFactoryList() {
        if (this.processorFactoryList == null) {
            this.processorFactoryList = new ArrayList<DetectorStreamProcessorFactory>();
        }
        return this.processorFactoryList;
    }

    public void addProcessorFactory(DetectorStreamProcessorFactory processorFactory) {
        this.getProcessorFactoryList().add(processorFactory);
    }

    public void setProcessorFactoryList(List<DetectorStreamProcessorFactory> processorFactoryList) {
        this.getInitializationState().requireNotInitilized();
        if (this.processorFactoryList != null) {
            throw new AlreadyInitializedException();
        }
        this.processorFactoryList = processorFactoryList;
    }

    @Inject
    public void setByteArrayPool(ByteArrayPool byteArrayPool) {
        this.byteArrayPool = byteArrayPool;
    }

    public ByteArrayPool getByteArrayPool() {
        return this.byteArrayPool;
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.getProcessorFactoryList().size() == 0) {
            throw new ResourceMissingException("processorFactoryList");
        }
        if (this.byteArrayPool == null) {
            this.byteArrayPool = NoByteArrayPool.INSTANCE;
        }
    }

    @Override
    public DetectorInputStream wrapInputStream(InputStream stream) {
        return this.wrapInputStream(stream, new HashMap());
    }

    @Override
    public DetectorOutputStream wrapOutputStream(OutputStream stream) {
        return this.wrapOutputStream(stream, new HashMap());
    }
}

