/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.io.base;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.io.api.RuntimeIoException;

public class AppendableWriter
extends Writer {
    private final Appendable appendable;

    public AppendableWriter(Appendable appendable) {
        this.appendable = appendable;
    }

    @Override
    public void close() throws RuntimeIoException {
        try {
            if (this.appendable instanceof Closeable) {
                ((Closeable)((Object)this.appendable)).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.CLOSE);
        }
    }

    @Override
    public void flush() throws RuntimeIoException {
        try {
            if (this.appendable instanceof Flushable) {
                ((Flushable)((Object)this.appendable)).flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.FLUSH);
        }
    }

    @Override
    public AppendableWriter append(char c) throws RuntimeIoException {
        try {
            this.appendable.append(c);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.WRITE);
        }
    }

    @Override
    public AppendableWriter append(CharSequence csq) throws RuntimeIoException {
        try {
            this.appendable.append(csq);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.WRITE);
        }
    }

    @Override
    public AppendableWriter append(CharSequence csq, int start, int end) throws RuntimeIoException {
        try {
            this.appendable.append(csq, start, end);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.WRITE);
        }
    }

    @Override
    public void write(char[] buffer) throws RuntimeIoException {
        this.append(new String(buffer));
    }

    @Override
    public void write(String string) throws RuntimeIoException {
        this.append(string);
    }

    @Override
    public void write(String string, int offset, int length) throws RuntimeIoException {
        this.append(string, offset, offset + length);
    }

    @Override
    public void write(char[] buffer, int offset, int length) throws RuntimeIoException {
        this.append(new String(buffer, offset, length));
    }

    public Appendable getAppendable() {
        return this.appendable;
    }
}

