/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.io.base;

import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.io.base.AbstractByteArray;

public class ByteArrayImpl
extends AbstractByteArray {
    private final byte[] buffer;
    private int minimumIndex;
    private int maximumIndex;

    public ByteArrayImpl(int capacity) {
        this(new byte[capacity], 0, -1);
    }

    public ByteArrayImpl(byte[] buffer) {
        this(buffer, 0, buffer.length - 1);
    }

    public ByteArrayImpl(byte[] buffer, int startIndex, int maximumIndex) {
        if (buffer == null) {
            throw new NlsNullPointerException("buffer");
        }
        this.buffer = buffer;
        this.minimumIndex = startIndex;
        this.maximumIndex = maximumIndex;
    }

    @Override
    public byte[] getBytes() {
        return this.buffer;
    }

    @Override
    public int getCurrentIndex() {
        return this.minimumIndex;
    }

    @Override
    public int getMinimumIndex() {
        return this.minimumIndex;
    }

    @Override
    public int getMaximumIndex() {
        return this.maximumIndex;
    }

    protected void setMaximumIndex(int maximumIndex) {
        this.maximumIndex = maximumIndex;
    }

    @Override
    public ByteArrayImpl createSubArray(int minimum, int maximum) {
        this.checkSubArray(minimum, maximum);
        return new ByteArrayImpl(this.buffer, minimum, maximum);
    }

    public String toString() {
        return new String(this.buffer, this.minimumIndex, this.getBytesAvailable());
    }
}

