/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.io.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Locale;
import net.sf.mmm.util.collection.base.RankMap;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.io.api.ByteOrderMark;
import net.sf.mmm.util.io.api.ByteProcessor;
import net.sf.mmm.util.io.api.EncodingDetectionReader;
import net.sf.mmm.util.io.api.EncodingUtil;
import net.sf.mmm.util.io.api.ProcessableByteArrayBuffer;
import net.sf.mmm.util.io.impl.BufferInputStream;

public class EncodingUtilImpl
extends AbstractLoggableComponent
implements EncodingUtil {
    public static final byte UTF_8_CONTINUATION_BYTE_MIN = -128;
    public static final byte UTF_8_CONTINUATION_BYTE_MAX = -65;
    public static final byte UTF_8_TWO_BYTE_MIN = -62;
    public static final byte UTF_8_TWO_BYTE_MAX = -33;
    public static final byte UTF_8_THREE_BYTE_MIN = -32;
    public static final byte UTF_8_THREE_BYTE_MAX = -17;
    public static final byte UTF_8_FOUR_BYTE_MIN = -16;
    public static final byte UTF_8_FOUR_BYTE_MAX = -12;
    public static final byte UTF_16_FIRST_SURROGATE_MIN = -40;
    public static final byte UTF_16_FIRST_SURROGATE_MAX = -37;
    public static final byte UTF_16_SECOND_SURROGATE_MIN = -36;
    public static final byte UTF_16_SECOND_SURROGATE_MAX = -33;
    private static final int RANK_BOM = 20;
    private static final int RANK_UTF8_SEQUNCE = 10;
    private static final int RANK_UTF16_SURROGATE = 6;
    private static EncodingUtil instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EncodingUtil getInstance() {
        if (instance != null) return instance;
        Class<EncodingUtilImpl> clazz = EncodingUtilImpl.class;
        synchronized (EncodingUtilImpl.class) {
            if (instance != null) return instance;
            EncodingUtilImpl util = new EncodingUtilImpl();
            util.initialize();
            instance = util;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public EncodingDetectionReader createUtfDetectionReader(InputStream inputStream, String nonUtfEncoding) {
        String encoding = nonUtfEncoding;
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
            String enc = encoding.toLowerCase(Locale.US);
            if (enc.startsWith("utf") || enc.endsWith("ascii")) {
                encoding = "ISO-8859-1";
            }
        } else {
            String enc = encoding.toLowerCase(Locale.US);
            if (enc.startsWith("utf") || enc.endsWith("ascii")) {
                this.getLogger().info("using encoding '" + encoding + "' for 'nonUtfEncoding' does NOT really make sense.");
            }
        }
        return new UtfDetectionReader(inputStream, encoding);
    }

    protected class UtfDetectionReader
    extends EncodingDetectionReader {
        private static final int REQUIRED_LOOKAHEAD = 1024;
        private static final int BUFFER_SIZE = 2048;
        private final BufferInputStream inputStream;
        private final AsciiProcessor asciiProcessor;
        private final UtfDetectionProcessor detectionProcessor;
        private final ProcessableByteArrayBuffer detectionBuffer;
        private String encoding;
        private Reader reader;
        private int asciiBytesAvailable;
        private boolean eos;

        public UtfDetectionReader(InputStream inputStream, String nonUtfEncoding) {
            this.inputStream = new BufferInputStream(inputStream, 2048);
            if (nonUtfEncoding == null) {
                throw new NullPointerException();
            }
            this.asciiProcessor = new AsciiProcessor();
            this.detectionProcessor = new UtfDetectionProcessor(nonUtfEncoding);
            this.detectionBuffer = this.inputStream.createLookaheadBuffer();
        }

        @Override
        public String getEncoding() {
            if (this.encoding == null && this.eos) {
                return "US-ASCII";
            }
            return this.encoding;
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
            if (this.reader != null) {
                this.reader.close();
            }
        }

        @Override
        public int read(char[] buffer, int offset, int length) throws IOException {
            int bytesRead;
            int offPlusLen = offset + length;
            if (offset < 0 || length < 0 || offPlusLen < 0 || buffer.length < offPlusLen) {
                throw new IndexOutOfBoundsException();
            }
            if (length == 0) {
                return 0;
            }
            if (this.reader == null) {
                int off = offset;
                int lengthRest = length;
                while (lengthRest > 0) {
                    if (this.asciiBytesAvailable == 0) {
                        int nonAsciiOffset;
                        this.eos = this.inputStream.fill();
                        if (!this.detectionBuffer.hasNext()) {
                            assert (this.eos);
                            break;
                        }
                        int lookahead = (int)this.detectionBuffer.process(this.detectionProcessor, Integer.MAX_VALUE);
                        if (!this.eos && !this.detectionProcessor.maybeAscii && (nonAsciiOffset = (int)(this.detectionProcessor.bytePosition - this.detectionProcessor.firstNonAsciiPosition)) < 1024) {
                            this.encoding = this.detectionProcessor.getLowByteEncoding();
                            if (this.encoding == null) {
                                this.asciiBytesAvailable = lookahead - nonAsciiOffset - 1;
                            }
                        }
                        if (this.asciiBytesAvailable == 0) {
                            this.encoding = this.detectionProcessor.getEncoding();
                            if (this.encoding == null) {
                                this.asciiBytesAvailable = lookahead;
                            }
                        }
                    }
                    if (this.encoding == null) {
                        int asciiRead;
                        assert (this.asciiBytesAvailable > 0);
                        AsciiProcessor.access$302(this.asciiProcessor, buffer);
                        this.asciiProcessor.charOffset = off;
                        int asciiCount = this.asciiBytesAvailable;
                        if (asciiCount > lengthRest) {
                            asciiCount = lengthRest;
                        }
                        if ((asciiRead = (int)this.inputStream.process(this.asciiProcessor, asciiCount)) == 0) break;
                        this.asciiBytesAvailable -= asciiRead;
                        lengthRest -= asciiRead;
                        off += asciiRead;
                        continue;
                    }
                    if (EncodingUtilImpl.this.getLogger().isTraceEnabled()) {
                        EncodingUtilImpl.this.getLogger().trace("detected encoding '" + this.encoding + "'");
                    }
                    this.reader = new InputStreamReader((InputStream)this.inputStream, this.encoding);
                    return this.reader.read(buffer, off, lengthRest);
                }
                if ((bytesRead = length - lengthRest) == 0) {
                    assert (this.eos);
                    return -1;
                }
            } else {
                bytesRead = this.reader.read(buffer, offset, length);
            }
            return bytesRead;
        }
    }

    protected static class UtfDetectionProcessor
    implements ByteProcessor {
        private RankMap<String> encodingRankMap;
        private ByteOrderMark bom;
        private final String nonUtfEncoding;
        private boolean maybeAscii;
        private boolean maybeUtf8;
        private boolean maybeUtf16;
        private long bytePosition;
        private long firstNonAsciiPosition;
        private int[] zeroByteCounts;
        private Surrogate[] surrogates;
        private int utf8ContinuationByteCount;

        public UtfDetectionProcessor(String nonUtfEncoding) {
            this.nonUtfEncoding = nonUtfEncoding;
            this.zeroByteCounts = new int[4];
            this.surrogates = new Surrogate[4];
            this.encodingRankMap = new RankMap();
            this.maybeAscii = true;
            this.maybeUtf8 = true;
            this.maybeUtf16 = true;
        }

        @Override
        public int process(byte[] buffer, int offset, int length) {
            int len = offset + length;
            for (int i = offset; i < len; ++i) {
                byte b = buffer[i];
                if (b < 0) {
                    if (this.maybeAscii) {
                        this.maybeAscii = false;
                        this.firstNonAsciiPosition = this.bytePosition;
                        this.encodingRankMap.setUnacceptable((Object)"US-ASCII");
                    }
                    if (this.bytePosition == 0L) {
                        i = this.processBom(buffer, offset, i);
                    }
                    if (this.maybeUtf8) {
                        this.processUtf8Detection(b);
                    }
                    if (this.maybeUtf16) {
                        this.processUtf16Detection(b);
                    }
                } else {
                    if (this.utf8ContinuationByteCount > 0) {
                        this.utf8ContinuationByteCount = 0;
                        this.maybeUtf8 = false;
                        this.encodingRankMap.setUnacceptable((Object)"UTF-8");
                    }
                    if (b == 0) {
                        int modulo4;
                        int n = modulo4 = (int)(this.bytePosition & 3L);
                        this.zeroByteCounts[n] = this.zeroByteCounts[n] + 1;
                    }
                }
                ++this.bytePosition;
            }
            return length;
        }

        private void processUtf16Detection(byte b) {
            int modulo4 = (int)(this.bytePosition & 3L);
            this.surrogates[modulo4] = null;
            if (b >= -40 && b <= -33) {
                this.surrogates[modulo4] = b <= -37 ? Surrogate.FIRST : Surrogate.SECOND;
                int last = modulo4 - 2 & 3;
                if (this.surrogates[last] != null) {
                    if (this.surrogates[last] == this.surrogates[modulo4]) {
                        this.maybeUtf16 = false;
                        this.encodingRankMap.setUnacceptable((Object)"UTF-16LE");
                        this.encodingRankMap.setUnacceptable((Object)"UTF-16BE");
                    } else if ((modulo4 & 1) == 0) {
                        this.encodingRankMap.addRank((Object)"UTF-16BE", 6);
                    } else {
                        this.encodingRankMap.addRank((Object)"UTF-16LE", 6);
                    }
                }
            }
        }

        private void processUtf8Detection(byte b) {
            if (this.utf8ContinuationByteCount > 0) {
                if (b >= -128 && b <= -65) {
                    --this.utf8ContinuationByteCount;
                    if (this.utf8ContinuationByteCount == 0) {
                        this.encodingRankMap.addRank((Object)"UTF-8", 10);
                    }
                } else {
                    this.utf8ContinuationByteCount = 0;
                    this.maybeUtf8 = false;
                    this.encodingRankMap.setUnacceptable((Object)"UTF-8");
                }
            } else if (b >= -62 && b <= -33) {
                this.utf8ContinuationByteCount = 1;
            } else if (b >= -32 && b <= -17) {
                this.utf8ContinuationByteCount = 2;
            } else if (b >= -16 && b <= -12) {
                this.utf8ContinuationByteCount = 3;
            } else {
                this.maybeUtf8 = false;
                this.encodingRankMap.setUnacceptable((Object)"UTF-8");
            }
        }

        private int processBom(byte[] buffer, int offset, int i) {
            int resultIndex = i;
            this.bom = ByteOrderMark.detect(buffer, offset);
            if (this.bom != null) {
                String encoding = this.bom.getEncoding();
                this.encodingRankMap.addRank((Object)encoding, 20);
                switch (this.bom) {
                    case UTF_8: {
                        this.maybeUtf16 = false;
                        break;
                    }
                    case UTF_16_BE: {
                        this.maybeUtf8 = false;
                        this.encodingRankMap.setUnacceptable((Object)"UTF-16LE");
                        break;
                    }
                    case UTF_16_LE: {
                        this.maybeUtf8 = false;
                        this.encodingRankMap.setUnacceptable((Object)"UTF-16BE");
                        break;
                    }
                    case UTF_32_BE: {
                        this.maybeUtf8 = false;
                        this.maybeUtf16 = false;
                        this.encodingRankMap.setUnacceptable((Object)"UTF-32LE");
                        break;
                    }
                    case UTF_32_LE: {
                        this.maybeUtf8 = false;
                        this.maybeUtf16 = false;
                        this.encodingRankMap.setUnacceptable((Object)"UTF-32BE");
                        break;
                    }
                }
                int add = this.bom.getLength() - 1;
                resultIndex += add;
                this.bytePosition = add;
            }
            return resultIndex;
        }

        public String getLowByteEncoding() {
            int evenZeroCount = this.zeroByteCounts[0] + this.zeroByteCounts[2];
            int oddZeroCount = this.zeroByteCounts[1] + this.zeroByteCounts[3];
            int zeroCount = evenZeroCount + oddZeroCount;
            if (zeroCount > 0) {
                int highZeroCount;
                if (this.maybeUtf16) {
                    if (evenZeroCount == 0) {
                        return "UTF-16LE";
                    }
                    if (oddZeroCount == 0) {
                        return "UTF-16BE";
                    }
                }
                if ((highZeroCount = this.zeroByteCounts[0] + this.zeroByteCounts[1]) == 0) {
                    return "UTF-32LE";
                }
                int lowZeroCount = this.zeroByteCounts[2] + this.zeroByteCounts[3];
                if (lowZeroCount == 0) {
                    return "UTF-32BE";
                }
            }
            return null;
        }

        public String getEncoding() {
            String encoding;
            if (this.maybeAscii) {
                encoding = this.getLowByteEncoding();
            } else {
                encoding = (String)this.encodingRankMap.getBest();
                if (encoding == null) {
                    encoding = this.nonUtfEncoding;
                }
            }
            return encoding;
        }
    }

    protected static class AsciiProcessor
    implements ByteProcessor {
        private char[] charBuffer = null;
        private int charOffset = 0;

        @Override
        public int process(byte[] buffer, int offset, int length) {
            int len = offset + length;
            for (int i = offset; i < len; ++i) {
                this.charBuffer[this.charOffset++] = (char)buffer[i];
            }
            return length;
        }

        static /* synthetic */ char[] access$302(AsciiProcessor x0, char[] x1) {
            x0.charBuffer = x1;
            return x1;
        }
    }

    protected static enum Surrogate {
        FIRST,
        SECOND;

    }
}

