/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.io.base;

import java.io.IOException;
import java.io.Writer;

public class EscapeWriter
extends Writer {
    private final String[] characterEscapingTable;
    private final Writer writer;

    public EscapeWriter(String[] charEscapeTable, Writer plainWriter) {
        this.writer = plainWriter;
        this.characterEscapingTable = charEscapeTable;
    }

    public EscapeWriter(Object syncLock, String[] charEscapeTable, Writer plainWriter) {
        super(syncLock);
        this.writer = plainWriter;
        this.characterEscapingTable = charEscapeTable;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int start = off;
        int end = off + len;
        int index = start;
        int count = 0;
        while (index < end) {
            char c;
            if ((c = cbuf[index++]) < this.characterEscapingTable.length) {
                String escapeSequence = this.characterEscapingTable[c];
                if (escapeSequence != null) {
                    if (count > 0) {
                        this.writer.write(cbuf, start, count);
                        count = 0;
                    }
                    start = index;
                    this.writer.write(escapeSequence);
                    continue;
                }
                ++count;
                continue;
            }
            ++count;
        }
        if (count > 0) {
            this.writer.write(cbuf, start, count);
        }
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

