/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.io.base;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.Channel;
import java.nio.channels.WritableByteChannel;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import javax.inject.Inject;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.concurrent.api.Stoppable;
import net.sf.mmm.util.concurrent.base.SimpleExecutor;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.io.api.AsyncTransferrer;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.io.api.RuntimeIoException;
import net.sf.mmm.util.io.api.StreamUtil;
import net.sf.mmm.util.io.api.TransferCallback;
import net.sf.mmm.util.io.base.AppendableWriter;
import net.sf.mmm.util.pool.api.Pool;
import net.sf.mmm.util.pool.base.NoByteArrayPool;
import net.sf.mmm.util.pool.base.NoCharArrayPool;

public class StreamUtilImpl
extends AbstractLoggableComponent
implements StreamUtil {
    private static StreamUtil instance;
    private Executor executor = null;
    private Pool<byte[]> byteArrayPool = null;
    private Pool<char[]> charArrayPool = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StreamUtil getInstance() {
        if (instance != null) return instance;
        Class<StreamUtilImpl> clazz = StreamUtilImpl.class;
        synchronized (StreamUtilImpl.class) {
            if (instance != null) return instance;
            StreamUtilImpl util = new StreamUtilImpl();
            util.initialize();
            instance = util;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    @Inject
    public void setExecutor(Executor executor) {
        this.getInitializationState().requireNotInitilized();
        this.executor = executor;
    }

    protected Pool<byte[]> getByteArrayPool() {
        return this.byteArrayPool;
    }

    public void setByteArrayPool(Pool<byte[]> byteArrayPool) {
        this.getInitializationState().requireNotInitilized();
        this.byteArrayPool = byteArrayPool;
    }

    protected Pool<char[]> getCharArrayPool() {
        return this.charArrayPool;
    }

    public void setCharArrayPool(Pool<char[]> charArrayPool) {
        this.getInitializationState().requireNotInitilized();
        this.charArrayPool = charArrayPool;
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.executor == null) {
            this.executor = SimpleExecutor.INSTANCE;
        }
        if (this.byteArrayPool == null) {
            this.byteArrayPool = NoByteArrayPool.INSTANCE;
        }
        if (this.charArrayPool == null) {
            this.charArrayPool = NoCharArrayPool.INSTANCE;
        }
    }

    @Override
    public String read(Reader reader) throws RuntimeIoException {
        StringWriter writer = new StringWriter();
        this.transfer(reader, writer, false);
        return writer.toString();
    }

    @Override
    public long transfer(Reader reader, Writer writer, boolean keepWriterOpen) throws RuntimeIoException {
        ReaderTransferrer transferrer = new ReaderTransferrer(reader, writer, keepWriterOpen, null);
        long bytes = transferrer.transfer();
        return bytes;
    }

    /*
     * Exception decompiling
     */
    @Override
    public long transfer(FileInputStream inStream, OutputStream outStream, boolean keepOutStreamOpen) throws RuntimeIoException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long transfer(InputStream inStream, FileOutputStream outStream, boolean keepOutStreamOpen, long size) throws RuntimeIoException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public long transfer(InputStream inStream, OutputStream outStream, boolean keepOutStreamOpen) throws RuntimeIoException {
        StreamTransferrer transferrer = new StreamTransferrer(inStream, outStream, keepOutStreamOpen, null);
        long bytes = transferrer.transfer();
        return bytes;
    }

    @Override
    public AsyncTransferrer transferAsync(InputStream inStream, OutputStream outStream, boolean keepOutStreamOpen) {
        return this.transferAsync(inStream, outStream, keepOutStreamOpen, null);
    }

    @Override
    public AsyncTransferrer transferAsync(InputStream inStream, OutputStream outStream, boolean keepOutStreamOpen, TransferCallback callback) {
        StreamTransferrer transferrer = new StreamTransferrer(inStream, outStream, keepOutStreamOpen, callback);
        AsyncTransferrerImpl task = new AsyncTransferrerImpl(transferrer);
        this.executor.execute(task);
        return task;
    }

    @Override
    public AsyncTransferrer transferAsync(Reader reader, Writer writer, boolean keepWriterOpen) {
        return this.transferAsync(reader, writer, keepWriterOpen, null);
    }

    @Override
    public AsyncTransferrer transferAsync(Reader reader, Writer writer, boolean keepWriterOpen, TransferCallback callback) {
        ReaderTransferrer transferrer = new ReaderTransferrer(reader, writer, keepWriterOpen, callback);
        AsyncTransferrerImpl task = new AsyncTransferrerImpl(transferrer);
        this.executor.execute(task);
        return task;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Properties loadProperties(InputStream inStream) throws RuntimeIoException {
        try (InputStream is = inStream;){
            Properties properties = new Properties();
            properties.load(is);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.READ);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Properties loadProperties(Reader reader) throws RuntimeIoException {
        try (Reader r = reader;){
            Properties properties = new Properties();
            properties.load(r);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.READ);
        }
    }

    @Override
    public PrintWriter toPrintWriter(Appendable appendable) {
        NlsNullPointerException.checkNotNull(Appendable.class, (Object)appendable);
        if (appendable instanceof PrintWriter) {
            return (PrintWriter)appendable;
        }
        return new PrintWriter(this.toWriter(appendable));
    }

    @Override
    public Writer toWriter(Appendable appendable) {
        NlsNullPointerException.checkNotNull(Appendable.class, (Object)appendable);
        if (appendable instanceof Writer) {
            return (Writer)appendable;
        }
        return new AppendableWriter(appendable);
    }

    @Override
    public void close(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to close stream!", (Throwable)e);
        }
    }

    @Override
    public void close(OutputStream outputStream) {
        try {
            outputStream.close();
        }
        catch (Exception e) {
            throw new RuntimeIoException((Throwable)e, IoMode.CLOSE);
        }
    }

    @Override
    public void close(Writer writer) {
        try {
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeIoException((Throwable)e, IoMode.CLOSE);
        }
    }

    @Override
    public void close(Reader reader) {
        try {
            reader.close();
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to close reader!", (Throwable)e);
        }
    }

    @Override
    public void close(Channel channel) {
        try {
            channel.close();
        }
        catch (Exception e) {
            if (channel instanceof WritableByteChannel) {
                throw new RuntimeIoException((Throwable)e, IoMode.CLOSE);
            }
            this.getLogger().warn("Failed to close channel!", (Throwable)e);
        }
    }

    protected class ReaderTransferrer
    extends BaseTransferrer<char[]> {
        private final Reader source;
        private final Writer destination;

        public ReaderTransferrer(Reader source, Writer destination, boolean keepDestinationOpen, TransferCallback callback) {
            super(callback, keepDestinationOpen);
            this.source = source;
            this.destination = destination;
        }

        @Override
        protected Reader getSource() {
            return this.source;
        }

        @Override
        protected Writer getDestination() {
            return this.destination;
        }

        @Override
        protected Pool<char[]> getPool() {
            return StreamUtilImpl.this.getCharArrayPool();
        }

        @Override
        public long transfer(char[] buffer) throws IOException {
            long bytesTransferred = 0L;
            int count = this.source.read(buffer);
            while (count > 0 && !this.isStopped()) {
                this.destination.write(buffer, 0, count);
                bytesTransferred += (long)count;
                count = this.source.read(buffer);
            }
            if (count == -1) {
                this.setCompleted();
            }
            return bytesTransferred;
        }
    }

    protected class StreamTransferrer
    extends BaseTransferrer<byte[]> {
        private final InputStream source;
        private final OutputStream destination;

        public StreamTransferrer(InputStream source, OutputStream destination, boolean keepDestinationOpen, TransferCallback callback) {
            super(callback, keepDestinationOpen);
            this.source = source;
            this.destination = destination;
        }

        @Override
        protected InputStream getSource() {
            return this.source;
        }

        @Override
        protected OutputStream getDestination() {
            return this.destination;
        }

        @Override
        protected Pool<byte[]> getPool() {
            return StreamUtilImpl.this.getByteArrayPool();
        }

        @Override
        public long transfer(byte[] buffer) throws IOException {
            long bytesTransferred = 0L;
            int count = this.source.read(buffer);
            while (count > 0 && !this.isStopped()) {
                this.destination.write(buffer, 0, count);
                bytesTransferred += (long)count;
                count = this.source.read(buffer);
            }
            if (count == -1) {
                this.setCompleted();
            }
            return bytesTransferred;
        }
    }

    protected abstract class BaseTransferrer<BUFFER>
    extends AbstractAsyncTransferrer {
        private final TransferCallback callback;
        private final boolean keepDestinationOpen;

        public BaseTransferrer(TransferCallback callback, boolean keepDestinationOpen) {
            this.callback = callback;
            this.keepDestinationOpen = keepDestinationOpen;
        }

        protected abstract Closeable getSource();

        protected abstract Closeable getDestination();

        protected abstract Pool<BUFFER> getPool();

        protected abstract long transfer(BUFFER var1) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected long transfer() throws RuntimeIoException {
            RuntimeIoException ex;
            boolean bl;
            long l;
            BUFFER buffer = this.getPool().borrow();
            RuntimeIoException t = null;
            try {
                l = this.transfer(buffer);
                bl = t == null;
            }
            catch (Exception e) {
                try {
                    t = new RuntimeIoException((Throwable)e, IoMode.COPY);
                    throw t;
                }
                catch (Throwable throwable) {
                    boolean doThrow2;
                    block33: {
                        block32: {
                            doThrow2 = t == null;
                            try {
                                this.getSource().close();
                            }
                            catch (Exception e2) {
                                RuntimeIoException ex2 = new RuntimeIoException((Throwable)e2, IoMode.CLOSE);
                                if (t != null) {
                                    t.addSuppressed((Throwable)ex2);
                                    break block32;
                                }
                                t = ex2;
                            }
                        }
                        if (!this.keepDestinationOpen) {
                            try {
                                this.getDestination().close();
                            }
                            catch (Exception e3) {
                                RuntimeIoException ex2 = new RuntimeIoException((Throwable)e3, IoMode.CLOSE);
                                if (t != null) {
                                    t.addSuppressed((Throwable)ex2);
                                    break block33;
                                }
                                t = ex2;
                            }
                        }
                    }
                    RuntimeException rte2 = null;
                    try {
                        this.getPool().release(buffer);
                        throw throwable;
                    }
                    catch (RuntimeException e4) {
                        rte2 = e4;
                        return (long)rte2;
                    }
                    finally {
                        if (rte2 != null) {
                            if (t == null) {
                                throw rte2;
                            }
                            t.addSuppressed((Throwable)rte2);
                        }
                        if (t == null) throw throwable;
                        if (!doThrow2) throw throwable;
                        throw t;
                    }
                }
            }
            boolean doThrow = bl;
            try {
                this.getSource().close();
            }
            catch (Exception e) {
                ex = new RuntimeIoException((Throwable)e, IoMode.CLOSE);
                if (t != null) {
                    t.addSuppressed((Throwable)ex);
                }
                t = ex;
            }
            if (!this.keepDestinationOpen) {
                try {
                    this.getDestination().close();
                }
                catch (Exception e) {
                    ex = new RuntimeIoException((Throwable)e, IoMode.CLOSE);
                    if (t != null) {
                        t.addSuppressed((Throwable)ex);
                    }
                    t = ex;
                }
            }
            RuntimeException rte = null;
            try {
                this.getPool().release(buffer);
                return l;
            }
            catch (RuntimeException e) {
                rte = e;
                return (long)rte;
            }
            finally {
                if (rte != null) {
                    if (t == null) {
                        throw rte;
                    }
                    t.addSuppressed((Throwable)rte);
                }
                if (t == null) return l;
                if (!doThrow) return l;
                throw t;
            }
        }

        @Override
        public Long call() throws Exception {
            try {
                long bytes = this.transfer();
                if (this.callback != null) {
                    if (this.isCompleted()) {
                        this.callback.transferCompleted(bytes);
                    } else {
                        this.callback.transferStopped(bytes);
                    }
                }
                return bytes;
            }
            catch (Exception e) {
                StreamUtilImpl.this.getLogger().error("Error during async transfer!", (Throwable)e);
                if (this.callback != null) {
                    this.callback.transferFailed(e);
                }
                throw e;
            }
        }
    }

    protected static abstract class AbstractAsyncTransferrer
    implements Callable<Long>,
    Stoppable {
        private volatile boolean stopped;
        private volatile boolean completed;

        protected AbstractAsyncTransferrer() {
        }

        public void stop() {
            this.stopped = true;
        }

        public final boolean isStopped() {
            return this.stopped;
        }

        public final boolean isCompleted() {
            return this.completed;
        }

        protected void setCompleted() {
            this.completed = true;
        }
    }

    protected static class AsyncTransferrerImpl
    extends FutureTask<Long>
    implements AsyncTransferrer {
        private final BaseTransferrer<?> transferrer;

        public AsyncTransferrerImpl(BaseTransferrer<?> transferrer) {
            super(transferrer);
            this.transferrer = transferrer;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.transferrer.stop();
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

