/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.io.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;
import net.sf.mmm.util.exception.api.ValueOutOfRangeException;
import net.sf.mmm.util.io.api.BufferExceedException;
import net.sf.mmm.util.io.api.ByteArray;
import net.sf.mmm.util.io.api.ByteArrayBuffer;
import net.sf.mmm.util.io.api.ByteProcessor;
import net.sf.mmm.util.io.api.ComposedByteBuffer;
import net.sf.mmm.util.io.api.ProcessableByteArrayBuffer;
import net.sf.mmm.util.io.base.ByteArrayImpl;
import net.sf.mmm.util.io.impl.ByteArrayBufferImpl;

public abstract class AbstractByteArrayBufferBuffer
implements ProcessableByteArrayBuffer,
ComposedByteBuffer {
    private final ByteArrayBufferImpl[] buffers;
    private int buffersIndex;
    private int buffersEndIndex;
    private int bufferStepCount;
    private int currentBufferIndex;
    private int currentBufferMax;
    private byte[] currentBufferBytes;

    public AbstractByteArrayBufferBuffer(ByteArrayBufferImpl ... buffers) {
        this.buffers = buffers;
        this.buffersIndex = 0;
        this.buffersEndIndex = 0;
        this.bufferStepCount = 0;
        ByteArrayBufferImpl buffer = this.buffers[this.buffersIndex];
        this.currentBufferIndex = buffer.getCurrentIndex();
        this.currentBufferMax = buffer.getMaximumIndex();
        this.currentBufferBytes = buffer.getBytes();
        while (buffer.hasNext()) {
            ++this.buffersEndIndex;
            if (this.buffersEndIndex < this.buffers.length) {
                buffer = this.buffers[this.buffersIndex];
                continue;
            }
            --this.buffersEndIndex;
            break;
        }
    }

    protected AbstractByteArrayBufferBuffer(AbstractByteArrayBufferBuffer template) {
        this.buffers = template.buffers;
        this.buffersEndIndex = template.buffersEndIndex;
        this.buffersIndex = template.buffersIndex;
        this.bufferStepCount = template.bufferStepCount;
        this.currentBufferBytes = template.currentBufferBytes;
        this.currentBufferIndex = template.currentBufferIndex;
        this.currentBufferMax = template.currentBufferMax;
    }

    protected ByteArrayBuffer getCurrentBuffer() {
        return this.buffers[this.buffersIndex];
    }

    protected int getCurrentBufferIndex() {
        return this.currentBufferIndex;
    }

    protected boolean nextBuffer() {
        if (this.buffersIndex == this.buffersEndIndex) {
            return false;
        }
        ++this.bufferStepCount;
        ++this.buffersIndex;
        if (this.buffersIndex >= this.buffers.length) {
            this.buffersIndex = 0;
        }
        ByteArrayBufferImpl buffer = this.buffers[this.buffersIndex];
        this.currentBufferBytes = buffer.getBytes();
        this.currentBufferIndex = buffer.getCurrentIndex();
        this.currentBufferMax = buffer.getMaximumIndex();
        return true;
    }

    @Override
    public int getBytesAvailable() {
        int count = this.currentBufferMax - this.currentBufferIndex + 1;
        int i = this.buffersIndex;
        while (i != this.buffersEndIndex) {
            if (++i >= this.buffers.length) {
                i = 0;
            }
            ByteArrayBufferImpl buffer = this.buffers[i];
            count += buffer.getBytesAvailable();
        }
        return count;
    }

    @Override
    public boolean hasNext() {
        if (this.currentBufferIndex <= this.currentBufferMax) {
            return true;
        }
        return this.nextBuffer();
    }

    @Override
    public byte next() throws NoSuchElementException {
        if (this.currentBufferIndex <= this.currentBufferMax) {
            byte result = this.currentBufferBytes[this.currentBufferIndex++];
            if (this.currentBufferIndex > this.currentBufferMax) {
                this.nextBuffer();
            }
            return result;
        }
        throw new NoSuchElementException();
    }

    @Override
    public byte peek() throws NoSuchElementException {
        if (this.currentBufferIndex <= this.currentBufferMax) {
            return this.currentBufferBytes[this.currentBufferIndex];
        }
        throw new NoSuchElementException();
    }

    @Override
    public long skip(long byteCount) {
        return this.process(null, byteCount);
    }

    @Override
    public long process(ByteProcessor processor, long byteCount) {
        if (byteCount < 0L) {
            throw new NlsIllegalArgumentException((Object)byteCount);
        }
        long count = byteCount;
        while (count > 0L) {
            boolean hasNext;
            int bytesLeft = this.currentBufferMax - this.currentBufferIndex + 1;
            int len = (long)bytesLeft > count ? (int)count : bytesLeft;
            int consumed = len;
            if (processor != null && ((consumed = processor.process(this.currentBufferBytes, this.currentBufferIndex, len)) < 0 || consumed > len)) {
                throw new ValueOutOfRangeException((Object)consumed, (Object)0, (Object)len, (Object)processor);
            }
            this.currentBufferIndex += consumed;
            if ((count -= (long)consumed) != 0L && consumed >= len && this.currentBufferIndex > this.currentBufferMax && (hasNext = this.nextBuffer())) continue;
            break;
        }
        return byteCount - count;
    }

    protected void sync(AbstractByteArrayBufferBuffer master) {
        this.buffersEndIndex = master.buffersEndIndex;
        int bufferDist = master.bufferStepCount - this.bufferStepCount;
        if (bufferDist > 0) {
            this.buffersIndex = master.buffersIndex;
            this.bufferStepCount = master.bufferStepCount;
            ByteArrayBufferImpl buffer = this.buffers[this.buffersIndex];
            this.currentBufferBytes = buffer.getBytes();
            this.currentBufferIndex = buffer.getCurrentIndex();
            this.currentBufferMax = buffer.getMaximumIndex();
        }
    }

    protected boolean fill(InputStream inputStream) throws IOException {
        int nextEnd = this.buffersEndIndex + 1;
        if (nextEnd >= this.buffers.length) {
            nextEnd = 0;
        }
        boolean todo = true;
        while (todo) {
            ByteArrayBufferImpl buffer = this.buffers[nextEnd];
            if (nextEnd == this.buffersIndex) {
                if (buffer.hasNext()) break;
                this.nextBuffer();
                todo = false;
            }
            if (nextEnd != this.buffersIndex) {
                int bytes = inputStream.read(buffer.getBytes());
                if (bytes == 0) {
                    bytes = inputStream.read(buffer.getBytes());
                }
                if (bytes > 0) {
                    buffer.setCurrentIndex(0);
                    buffer.setMaximumIndex(bytes - 1);
                } else {
                    assert (bytes == -1);
                    return true;
                }
            }
            this.buffersEndIndex = nextEnd++;
            if (nextEnd < this.buffers.length) continue;
            nextEnd = 0;
        }
        return false;
    }

    @Override
    public int fill(byte[] buffer, int offset, int length) {
        if (offset >= buffer.length) {
            throw new BufferExceedException(offset, buffer.length);
        }
        if (length + offset > buffer.length) {
            throw new BufferExceedException(length, buffer.length - offset);
        }
        if (!this.hasNext()) {
            return 0;
        }
        int bufferIndex = offset;
        int bytesLeft = length;
        while (bytesLeft > 0) {
            boolean bufferLeft;
            int count = this.currentBufferMax - this.currentBufferIndex + 1;
            if (count > bytesLeft) {
                count = bytesLeft;
                bytesLeft = 0;
            } else {
                bytesLeft -= count;
            }
            System.arraycopy(this.currentBufferBytes, this.currentBufferIndex, buffer, bufferIndex, count);
            bufferIndex += count;
            this.currentBufferIndex += count;
            if (this.currentBufferIndex <= this.currentBufferMax || (bufferLeft = this.nextBuffer())) continue;
            break;
        }
        return length - bytesLeft;
    }

    @Override
    public ByteArray getByteArray(int index) {
        assert (index >= 0);
        assert (index < this.getByteArrayCount());
        if (index == 0) {
            return new ByteArrayImpl(this.currentBufferBytes, this.currentBufferIndex, this.currentBufferMax);
        }
        int newIndex = this.buffersIndex + index;
        if (newIndex > this.buffers.length) {
            if (this.buffersIndex <= this.buffersEndIndex) {
                newIndex -= this.buffers.length;
            } else {
                throw new NlsIllegalArgumentException((Object)index);
            }
        }
        if (newIndex > this.buffersEndIndex) {
            throw new NlsIllegalArgumentException((Object)index);
        }
        return this.buffers[newIndex];
    }

    @Override
    public int getByteArrayCount() {
        if (this.buffersIndex <= this.buffersEndIndex) {
            return this.buffersEndIndex - this.buffersIndex + 1;
        }
        return this.buffers.length - this.buffersIndex + this.buffersEndIndex;
    }
}

