/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.io.impl;

import java.io.IOException;
import java.io.InputStream;
import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;
import net.sf.mmm.util.io.api.ByteProcessable;
import net.sf.mmm.util.io.api.ByteProcessor;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.io.api.ProcessableByteArrayBuffer;
import net.sf.mmm.util.io.api.RuntimeIoException;
import net.sf.mmm.util.io.impl.ByteArrayBufferBuffer;
import net.sf.mmm.util.io.impl.ByteArrayBufferImpl;
import net.sf.mmm.util.io.impl.LookaheadByteArrayBufferBuffer;

public class BufferInputStream
extends InputStream
implements ByteProcessable {
    private static final int DEFAULT_CAPACITY = 2048;
    private InputStream inStream;
    private final ByteArrayBufferBuffer buffer;
    private boolean eos;
    private CopyProcessor copyProcessor;

    public BufferInputStream(InputStream inStream) {
        this(inStream, 2048);
    }

    public BufferInputStream(InputStream inStream, int capacity) {
        this(inStream, capacity, 2);
    }

    private BufferInputStream(InputStream inStream, int capacity, int bufferCount) {
        this.inStream = inStream;
        ByteArrayBufferImpl[] buffers = new ByteArrayBufferImpl[bufferCount];
        for (int i = 0; i < bufferCount; ++i) {
            buffers[i] = new ByteArrayBufferImpl(capacity);
        }
        this.buffer = new ByteArrayBufferBuffer(buffers);
        this.copyProcessor = new CopyProcessor();
    }

    protected void ensureOpen() throws IOException {
        if (this.inStream == null) {
            throw new IOException("Stream closed!");
        }
    }

    @Override
    public void close() throws IOException {
        InputStream stream = this.inStream;
        if (stream != null) {
            this.inStream = null;
            stream.close();
        }
    }

    public boolean fill() throws IOException {
        if (!this.eos) {
            this.eos = this.buffer.fill(this.inStream);
        }
        return this.eos;
    }

    @Override
    public long skip(long skipCount) throws IOException {
        if (skipCount < 0L) {
            throw new NlsIllegalArgumentException((Object)skipCount);
        }
        if (skipCount == 0L) {
            return 0L;
        }
        long skipped = this.buffer.skip(skipCount);
        if (skipped < skipCount && !this.eos) {
            skipped += this.inStream.skip(skipCount - skipped);
        }
        this.fill();
        return skipped;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (!this.buffer.hasNext()) {
            this.fill();
            if (this.eos) {
                return -1;
            }
        }
        byte result = this.buffer.next();
        this.fill();
        return result;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        this.ensureOpen();
        int offPlusLen = offset + length;
        if (offset < 0 || length < 0 || offPlusLen < 0 || bytes.length < offPlusLen) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        CopyProcessor.access$002(this.copyProcessor, bytes);
        this.copyProcessor.targetOffset = offset;
        int processed = (int)this.buffer.process(this.copyProcessor, length);
        int len = length - processed;
        if (len > 0) {
            int bytesRead = this.inStream.read(bytes, offset + processed, len);
            if (bytesRead == -1) {
                if (processed == 0) {
                    return -1;
                }
            } else {
                processed += bytesRead;
            }
        }
        this.fill();
        return processed;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.getBytesAvailable() + this.inStream.available();
    }

    @Override
    public long process(ByteProcessor processor, long length) {
        try {
            long len;
            long processed;
            for (len = length; len > 0L; len -= processed) {
                this.fill();
                processed = this.buffer.process(processor, length);
                if (processed > 0L) continue;
                assert (processed == 0L);
                break;
            }
            return length - len;
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.READ);
        }
    }

    public ProcessableByteArrayBuffer createLookaheadBuffer() {
        return new LookaheadByteArrayBufferBuffer(this.buffer);
    }

    protected static class CopyProcessor
    implements ByteProcessor {
        private byte[] targetBuffer;
        private int targetOffset;

        public CopyProcessor() {
        }

        public CopyProcessor(byte[] targetBuffer, int targetOffset) {
            this.targetBuffer = targetBuffer;
            this.targetOffset = targetOffset;
        }

        @Override
        public int process(byte[] buffer, int offset, int length) {
            System.arraycopy(buffer, offset, this.targetBuffer, this.targetOffset, length);
            this.targetOffset += length;
            return length;
        }

        static /* synthetic */ byte[] access$002(CopyProcessor x0, byte[] x1) {
            x0.targetBuffer = x1;
            return x1;
        }
    }
}

