/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.io.impl;

import java.util.NoSuchElementException;
import net.sf.mmm.util.exception.api.ValueOutOfRangeException;
import net.sf.mmm.util.io.api.ByteArrayBuffer;
import net.sf.mmm.util.io.base.ByteArrayImpl;

public class ByteArrayBufferImpl
extends ByteArrayImpl
implements ByteArrayBuffer {
    private int currentIndex;

    public ByteArrayBufferImpl(int capacity) {
        super(capacity);
    }

    public ByteArrayBufferImpl(byte[] buffer) {
        super(buffer);
        this.currentIndex = 0;
    }

    public ByteArrayBufferImpl(byte[] buffer, int currentIndex, int maximumIndex) {
        super(buffer, currentIndex, maximumIndex);
        this.currentIndex = currentIndex;
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public void setCurrentIndex(int currentIndex) {
        ValueOutOfRangeException.checkRange((Object)currentIndex, (Object)this.getMinimumIndex(), (Object)(this.getMaximumIndex() + 1), (Object)"currentIndex");
        this.currentIndex = currentIndex;
    }

    @Override
    public void setMaximumIndex(int maximumIndex) {
        super.setMaximumIndex(maximumIndex);
    }

    @Override
    public byte next() throws NoSuchElementException {
        if (this.currentIndex > this.getMaximumIndex()) {
            throw new NoSuchElementException();
        }
        return this.getBytes()[this.currentIndex++];
    }

    @Override
    public byte peek() throws NoSuchElementException {
        if (this.currentIndex > this.getMaximumIndex()) {
            throw new NoSuchElementException();
        }
        return this.getBytes()[this.currentIndex];
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex <= this.getMaximumIndex();
    }

    @Override
    public long skip(long byteCount) {
        int bytesLeft = this.getMaximumIndex() - this.currentIndex + 1;
        int skip = (long)bytesLeft > byteCount ? (int)byteCount : bytesLeft;
        this.currentIndex += skip;
        return skip;
    }

    @Override
    public ByteArrayImpl createSubArray(int minimum, int maximum) {
        this.checkSubArray(minimum, maximum);
        return new ByteArrayBufferImpl(this.getBytes(), minimum, maximum);
    }
}

