/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.io.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;
import net.sf.mmm.util.io.api.BufferExceedException;
import net.sf.mmm.util.io.api.ByteArray;
import net.sf.mmm.util.io.api.spi.DetectorStreamBuffer;
import net.sf.mmm.util.io.api.spi.DetectorStreamProcessor;
import net.sf.mmm.util.io.base.AbstractByteArray;
import net.sf.mmm.util.io.base.ByteArrayImpl;
import net.sf.mmm.util.io.impl.PooledByteArray;
import net.sf.mmm.util.pool.api.ByteArrayPool;

public class DetectorStreamBufferImpl
implements DetectorStreamBuffer {
    private DetectorStreamProcessor processor;
    private DetectorStreamBufferImpl chainSuccessor;
    private long streamPosition;
    private long seekCount;
    private SeekMode seekMode;
    private ByteArray currentByteArray;
    private byte[] currentArray;
    private int currentArrayMin;
    private int currentArrayIndex;
    private int currentArrayMax;
    private final LinkedList<ByteArray> arrayQueue = new LinkedList();
    private final ByteArray currentArrayView;
    private ByteArrayPool byteArrayPool;

    public DetectorStreamBufferImpl(DetectorStreamProcessor processor, DetectorStreamBufferImpl successor, ByteArrayPool byteArrayPool) {
        this.chainSuccessor = successor;
        this.byteArrayPool = byteArrayPool;
        this.processor = processor;
        this.currentArrayView = new CurrentByteArray();
    }

    @Override
    public long skip(long byteCount) {
        this.seek(byteCount, SeekMode.SKIP);
        return byteCount;
    }

    @Override
    public long skip() {
        if (this.currentArray == null) {
            return 0L;
        }
        int bytesAvailable = this.currentArrayMax - this.currentArrayIndex + 1;
        if (this.chainSuccessor != null) {
            this.chainSuccessor.append(this.currentByteArray.createSubArray(this.currentArrayIndex, this.currentArrayMax));
        }
        this.release(this.currentByteArray);
        this.currentArray = null;
        Iterator arrayIterator = this.arrayQueue.iterator();
        while (arrayIterator.hasNext()) {
            ByteArray array = (ByteArray)arrayIterator.next();
            arrayIterator.remove();
            bytesAvailable += array.getBytesAvailable();
            if (this.chainSuccessor == null) {
                this.release(array);
                continue;
            }
            this.chainSuccessor.append(array);
        }
        return bytesAvailable;
    }

    @Override
    public ByteArray getByteArray(int index) {
        if (index == 0) {
            return this.currentArrayView;
        }
        return this.arrayQueue.get(index - 1);
    }

    @Override
    public int getByteArrayCount() {
        int arrayCount = this.arrayQueue.size();
        if (this.currentArray != null) {
            ++arrayCount;
        }
        return arrayCount;
    }

    @Override
    public int getBytesAvailable() {
        if (this.currentArray == null) {
            return 0;
        }
        int bytesAvailable = this.currentArrayMax - this.currentArrayIndex + 1;
        for (ByteArray array : this.arrayQueue) {
            bytesAvailable += array.getBytesAvailable();
        }
        return bytesAvailable;
    }

    @Override
    public boolean hasNext() {
        boolean okay;
        return this.currentArray != null || (okay = this.nextArray());
    }

    protected void release(ByteArray byteArray) {
        PooledByteArray pooledArray;
        if (byteArray instanceof PooledByteArray && (pooledArray = (PooledByteArray)byteArray).release()) {
            this.byteArrayPool.release(byteArray.getBytes());
        }
    }

    private boolean nextArray() {
        if (this.currentArray != null) {
            if (this.currentArrayMin < this.currentArrayMax && this.chainSuccessor != null && this.seekMode != SeekMode.REMOVE) {
                ByteArray subArray = this.currentByteArray.createSubArray(this.currentArrayMin, this.currentArrayMax);
                this.chainSuccessor.append(subArray);
            }
            this.release(this.currentByteArray);
        }
        if (this.arrayQueue.isEmpty()) {
            this.currentArray = null;
            return false;
        }
        ByteArray nextArray = this.arrayQueue.remove();
        int offsetMin = 0;
        int offsetIndex = 0;
        while (this.seekCount > 0L) {
            long bytesAvailable = nextArray.getBytesAvailable();
            if (this.seekCount >= bytesAvailable) {
                this.seekCount -= bytesAvailable;
                this.streamPosition += bytesAvailable;
                if (this.chainSuccessor != null && this.seekMode == SeekMode.SKIP) {
                    this.chainSuccessor.append(nextArray);
                } else {
                    this.release(this.currentByteArray);
                }
                if (this.arrayQueue.isEmpty()) {
                    this.currentArray = null;
                    return false;
                }
                nextArray = this.arrayQueue.remove();
                continue;
            }
            offsetIndex = (int)this.seekCount;
            if (this.seekMode == SeekMode.REMOVE) {
                offsetMin = offsetIndex;
            }
            this.streamPosition += this.seekCount;
            this.seekCount = 0L;
            this.seekMode = null;
        }
        this.currentByteArray = nextArray;
        this.currentArray = nextArray.getBytes();
        int currentIndex = nextArray.getCurrentIndex();
        this.currentArrayMin = currentIndex + offsetMin;
        this.currentArrayIndex = currentIndex + offsetIndex;
        this.currentArrayMax = nextArray.getMaximumIndex();
        if (this.currentArrayIndex > this.currentArrayMax) {
            return this.nextArray();
        }
        return true;
    }

    @Override
    public byte next() throws NoSuchElementException {
        if (this.currentArray == null) {
            throw new NoSuchElementException();
        }
        byte result = this.currentArray[this.currentArrayIndex++];
        ++this.streamPosition;
        if (this.currentArrayIndex > this.currentArrayMax) {
            this.nextArray();
        }
        return result;
    }

    @Override
    public byte peek() throws NoSuchElementException {
        if (this.currentArray == null) {
            throw new NoSuchElementException();
        }
        byte result = this.currentArray[this.currentArrayIndex];
        return result;
    }

    @Override
    public void insert(byte ... data) {
        this.insert(new ByteArrayImpl(data));
    }

    @Override
    public void insert(ByteArray data) {
        if (this.currentArray != null) {
            int max = this.currentArrayIndex - 1;
            if (this.currentArrayMin <= max) {
                this.chainSuccessor.append(new ByteArrayImpl(this.currentArray, this.currentArrayMin, max));
            }
            this.currentArrayMin = this.currentArrayIndex;
        }
        this.chainSuccessor.append(data);
    }

    protected void seek(long byteCount, SeekMode mode) {
        if (this.seekMode == null) {
            this.seekMode = mode;
        } else if (this.seekMode != mode) {
            throw new NlsIllegalArgumentException((Object)"remove and skip can NOT be mixed!");
        }
        this.seekCount += byteCount;
        if (this.currentArray != null) {
            long currentBytesAvailable;
            if (mode == SeekMode.REMOVE && this.currentArrayMin < this.currentArrayIndex) {
                ByteArray subArray = this.currentByteArray.createSubArray(this.currentArrayMin, this.currentArrayIndex - 1);
                this.chainSuccessor.append(subArray);
                this.currentArrayMin = this.currentArrayIndex;
            }
            if ((currentBytesAvailable = (long)(this.currentArrayMax - this.currentArrayIndex + 1)) > this.seekCount) {
                this.currentArrayIndex = (int)((long)this.currentArrayIndex + this.seekCount);
                this.seekCount = 0L;
                this.seekMode = null;
                if (mode == SeekMode.REMOVE) {
                    this.currentArrayMin = this.currentArrayIndex;
                }
            } else {
                this.seekCount -= currentBytesAvailable;
                this.nextArray();
                if (this.seekCount == 0L) {
                    this.seekMode = null;
                }
            }
        }
    }

    @Override
    public void remove(long byteCount) {
        this.seek(byteCount, SeekMode.REMOVE);
    }

    @Override
    public long getStreamPosition() {
        return this.streamPosition;
    }

    protected void append(ByteArray nextArray) {
        this.arrayQueue.add(nextArray);
        if (this.currentArray == null) {
            this.nextArray();
        }
    }

    public void process(Map<String, Object> metadata, boolean eos) throws IOException {
        this.processor.process(this, metadata, eos);
        if (this.chainSuccessor != null) {
            this.chainSuccessor.process(metadata, eos);
        }
    }

    @Override
    public int fill(byte[] buffer, int offset, int length) {
        if (offset >= buffer.length) {
            throw new BufferExceedException(offset, buffer.length);
        }
        if (length + offset > buffer.length) {
            throw new BufferExceedException(length, buffer.length - offset);
        }
        if (!this.hasNext()) {
            return -1;
        }
        int bufferIndex = offset;
        int bytesLeft = length;
        while (bytesLeft > 0) {
            boolean bufferLeft;
            int count = this.currentArrayMax - this.currentArrayIndex + 1;
            if (count > bytesLeft) {
                count = bytesLeft;
                bytesLeft = 0;
            } else {
                bytesLeft -= count;
            }
            System.arraycopy(this.currentArray, this.currentArrayIndex, buffer, bufferIndex, count);
            bufferIndex += count;
            this.currentArrayIndex += count;
            if (this.currentArrayIndex <= this.currentArrayMax || (bufferLeft = this.nextArray())) continue;
            break;
        }
        return length - bytesLeft;
    }

    protected static enum SeekMode {
        SKIP,
        REMOVE;

    }

    protected class CurrentByteArray
    extends AbstractByteArray {
        protected CurrentByteArray() {
        }

        @Override
        public byte[] getBytes() {
            return DetectorStreamBufferImpl.this.currentArray;
        }

        @Override
        public int getBytesAvailable() {
            return DetectorStreamBufferImpl.this.currentArrayMax - DetectorStreamBufferImpl.this.currentArrayIndex + 1;
        }

        @Override
        public int getMinimumIndex() {
            return DetectorStreamBufferImpl.this.currentArrayIndex;
        }

        @Override
        public int getCurrentIndex() {
            return DetectorStreamBufferImpl.this.currentArrayIndex;
        }

        @Override
        public int getMaximumIndex() {
            return DetectorStreamBufferImpl.this.currentArrayMax;
        }
    }
}

