/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.io.impl;

import net.sf.mmm.util.exception.api.NlsIllegalStateException;
import net.sf.mmm.util.io.base.ByteArrayImpl;

public class PooledByteArray
extends ByteArrayImpl {
    private final PooledByteArray parent;
    private int childCount;
    private boolean released;

    public PooledByteArray(byte[] buffer) {
        this(buffer, 0, buffer.length - 1);
    }

    public PooledByteArray(byte[] buffer, int startIndex, int maximumIndex) {
        this(buffer, startIndex, maximumIndex, null);
    }

    protected PooledByteArray(byte[] buffer, int startIndex, int maximumIndex, PooledByteArray parent) {
        super(buffer, startIndex, maximumIndex);
        this.parent = parent;
        this.childCount = 0;
    }

    @Override
    public ByteArrayImpl createSubArray(int minimum, int maximum) {
        if (this.parent != null && !this.parent.released) {
            return this.parent.createSubArray(minimum, maximum);
        }
        if (this.released) {
            throw new NlsIllegalStateException();
        }
        this.checkSubArray(minimum, maximum);
        ++this.childCount;
        return new PooledByteArray(this.getBytes(), minimum, maximum, this);
    }

    public boolean release() {
        if (this.released) {
            return false;
        }
        this.released = true;
        if (this.childCount == 0) {
            if (this.parent == null) {
                return true;
            }
            assert (this.parent.childCount > 0);
            --this.parent.childCount;
            if (this.parent.childCount == 0 && this.parent.released) {
                return true;
            }
        }
        return false;
    }
}

