/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.io.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.sf.mmm.util.exception.api.NlsIllegalStateException;
import net.sf.mmm.util.io.api.DetectorInputStream;
import net.sf.mmm.util.io.api.spi.DetectorStreamBuffer;
import net.sf.mmm.util.io.api.spi.DetectorStreamProcessor;
import net.sf.mmm.util.io.base.AbstractDetectorStreamProvider;
import net.sf.mmm.util.io.impl.PooledByteArray;
import net.sf.mmm.util.io.impl.ProcessableDetectorStream;

public class ProcessableDetectorInputStream
extends ProcessableDetectorStream
implements DetectorInputStream {
    private final WrapperInputStream wrapperInputStream;

    public ProcessableDetectorInputStream(InputStream inputStream, Map<String, Object> mutableMetadata, AbstractDetectorStreamProvider provider) {
        super(mutableMetadata, provider.getByteArrayPool());
        this.wrapperInputStream = new WrapperInputStream(inputStream);
        this.initialize(provider, this.wrapperInputStream);
    }

    @Override
    public InputStream getStream() {
        return this.wrapperInputStream;
    }

    protected class WrapperInputStream
    extends InputStream
    implements DetectorStreamProcessor {
        private final InputStream delegate;
        private DetectorStreamBuffer targetBuffer;
        private boolean endOfStream;

        public WrapperInputStream(InputStream inputStream) {
            this.delegate = inputStream;
            this.targetBuffer = null;
            this.endOfStream = false;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public int read() throws IOException {
            this.fill(1);
            if (this.targetBuffer.hasNext()) {
                return this.targetBuffer.next();
            }
            return -1;
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            this.fill(length);
            return this.targetBuffer.fill(buffer, offset, length);
        }

        @Override
        public long skip(long n) throws IOException {
            long rest;
            int bufferSize;
            if (n <= 0L) {
                return 0L;
            }
            if (this.targetBuffer == null) {
                this.fill(1);
            }
            for (rest = n; rest > 0L && (bufferSize = this.targetBuffer.getBytesAvailable()) != 0; rest -= (long)bufferSize) {
                if ((long)bufferSize < rest) {
                    this.targetBuffer.skip(bufferSize);
                } else {
                    this.targetBuffer.skip((int)rest);
                    rest = 0L;
                    break;
                }
                this.fill(1);
            }
            return n - rest;
        }

        protected void fill(int requiredBufferLength) throws IOException {
            int bufferLength = 0;
            if (this.targetBuffer != null) {
                bufferLength = this.targetBuffer.getBytesAvailable();
            }
            int readCount = 0;
            while (bufferLength < requiredBufferLength) {
                if (readCount > 15) {
                    throw new NlsIllegalStateException();
                }
                byte[] buffer = (byte[])ProcessableDetectorInputStream.this.getByteArrayPool().borrow();
                int length = this.delegate.read(buffer);
                ++readCount;
                if (length == 0 && (length = this.delegate.read(buffer)) == 0) {
                    throw new NlsIllegalStateException();
                }
                if (length == -1) {
                    ProcessableDetectorInputStream.this.processInternal(null, true);
                    ProcessableDetectorInputStream.this.getByteArrayPool().release(buffer);
                    return;
                }
                ProcessableDetectorInputStream.this.processInternal(new PooledByteArray(buffer, 0, length - 1), false);
                bufferLength = this.targetBuffer.getBytesAvailable();
            }
        }

        @Override
        public void process(DetectorStreamBuffer buffer, Map<String, Object> metadata, boolean eos) throws IOException {
            if (this.endOfStream) {
                // empty if block
            }
            this.targetBuffer = buffer;
            this.endOfStream = eos;
        }
    }
}

