/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.io.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import net.sf.mmm.util.io.api.ByteArray;
import net.sf.mmm.util.io.api.DetectorOutputStream;
import net.sf.mmm.util.io.api.spi.DetectorStreamBuffer;
import net.sf.mmm.util.io.api.spi.DetectorStreamProcessor;
import net.sf.mmm.util.io.base.AbstractDetectorStreamProvider;
import net.sf.mmm.util.io.base.ByteArrayImpl;
import net.sf.mmm.util.io.impl.PooledByteArray;
import net.sf.mmm.util.io.impl.ProcessableDetectorStream;

public class ProcessableDetectorOutputStream
extends ProcessableDetectorStream
implements DetectorOutputStream {
    private final WrapperOutputStream wrapperOutputStream;

    public ProcessableDetectorOutputStream(OutputStream outputStream, Map<String, Object> mutableMetadata, AbstractDetectorStreamProvider provider) {
        super(mutableMetadata, provider.getByteArrayPool());
        this.wrapperOutputStream = new WrapperOutputStream(outputStream);
        this.initialize(provider, this.wrapperOutputStream);
    }

    @Override
    public OutputStream getStream() {
        return this.wrapperOutputStream;
    }

    protected class WrapperOutputStream
    extends OutputStream
    implements DetectorStreamProcessor {
        private final OutputStream delegate;
        private byte[] bytes;
        private int count;

        public WrapperOutputStream(OutputStream outputStream) {
            this.delegate = outputStream;
            this.bytes = null;
            this.count = 0;
        }

        @Override
        public void close() throws IOException {
            this.flushBuffer();
            ProcessableDetectorOutputStream.this.processInternal(null, true);
        }

        @Override
        public void flush() throws IOException {
            this.flushBuffer();
            this.delegate.flush();
        }

        private void flushBuffer() throws IOException {
            if (this.count > 0) {
                ProcessableDetectorOutputStream.this.processInternal(new PooledByteArray(this.bytes, 0, this.count - 1), false);
                this.count = 0;
                this.bytes = null;
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.flushBuffer();
            ProcessableDetectorOutputStream.this.processInternal(new ByteArrayImpl(b, off, len - off - 1), false);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.flushBuffer();
            ProcessableDetectorOutputStream.this.processInternal(new ByteArrayImpl(b), false);
        }

        @Override
        public void write(int b) throws IOException {
            if (this.count > 0 && this.count >= this.bytes.length) {
                this.flushBuffer();
            }
            if (this.bytes == null) {
                this.bytes = (byte[])ProcessableDetectorOutputStream.this.getByteArrayPool().borrow();
            }
            this.bytes[this.count++] = (byte)b;
        }

        @Override
        public void process(DetectorStreamBuffer buffer, Map<String, Object> metadata, boolean eos) throws IOException {
            int arrayCount = buffer.getByteArrayCount();
            for (int i = 0; i < arrayCount; ++i) {
                ByteArray byteArray = buffer.getByteArray(i);
                this.delegate.write(byteArray.getBytes(), byteArray.getCurrentIndex(), byteArray.getBytesAvailable());
            }
            buffer.skip();
        }
    }
}

