/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.io.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.sf.mmm.util.io.api.ByteArray;
import net.sf.mmm.util.io.api.spi.DetectorStreamProcessor;
import net.sf.mmm.util.io.api.spi.DetectorStreamProcessorFactory;
import net.sf.mmm.util.io.base.AbstractDetectorStream;
import net.sf.mmm.util.io.base.AbstractDetectorStreamProvider;
import net.sf.mmm.util.io.impl.DetectorStreamBufferImpl;
import net.sf.mmm.util.pool.api.ByteArrayPool;

public abstract class ProcessableDetectorStream
extends AbstractDetectorStream {
    private final ByteArrayPool byteArrayPool;
    private DetectorStreamBufferImpl firstBuffer;

    public ProcessableDetectorStream(Map<String, Object> mutableMetadata, ByteArrayPool byteArrayPool) {
        super(mutableMetadata);
        this.byteArrayPool = byteArrayPool;
    }

    public void initialize(AbstractDetectorStreamProvider provider, DetectorStreamProcessor lastProcessor) {
        List<DetectorStreamProcessorFactory> factoryList = provider.getProcessorFactoryList();
        int factoryCount = factoryList.size();
        DetectorStreamBufferImpl buffer = new DetectorStreamBufferImpl(lastProcessor, null, this.byteArrayPool);
        for (int factoryIndex = factoryCount - 1; factoryIndex >= 0; --factoryIndex) {
            DetectorStreamProcessorFactory factory = factoryList.get(factoryIndex);
            DetectorStreamProcessor processor = factory.createProcessor();
            buffer = new DetectorStreamBufferImpl(processor, buffer, this.byteArrayPool);
        }
        this.firstBuffer = buffer;
    }

    public void processInternal(ByteArray buffer, boolean eos) throws IOException {
        if (buffer != null) {
            this.firstBuffer.append(buffer);
        }
        this.firstBuffer.process(this.getMutableMetadata(), eos);
        if (eos) {
            this.setDone();
        }
    }

    protected ByteArrayPool getByteArrayPool() {
        return this.byteArrayPool;
    }
}

