/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pool.base;

import net.sf.mmm.util.pool.api.Pool;

public abstract class AbstractPool<E>
implements Pool<E> {
    public static final int DEFAULT_CAPACITY = 16;
    private final Object[] pool;
    private final Object lock;
    private int size;

    public AbstractPool() {
        this(false, 16, null);
    }

    public AbstractPool(int capacity, boolean threadsafe) {
        this(threadsafe, 16, null);
    }

    public AbstractPool(int capacity, Object lock) {
        this(true, 16, lock);
        assert (lock != null);
    }

    private AbstractPool(boolean threadsafe, int capacity, Object lock) {
        if (threadsafe) {
            this.lock = lock == null ? this : lock;
        } else {
            assert (lock == null);
            this.lock = null;
        }
        this.pool = new Object[capacity];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E borrow() {
        if (this.lock == null) {
            return this.borrowInternal();
        }
        Object object = this.lock;
        synchronized (object) {
            return this.borrowInternal();
        }
    }

    private E borrowInternal() {
        if (this.size > 0) {
            Object element = this.pool[this.size];
            this.pool[this.size--] = null;
            return (E)element;
        }
        return this.create();
    }

    protected abstract E create();

    protected boolean reset(E element) {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public int getSize() {
        return this.size;
    }

    public int getCapacity() {
        return this.pool.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(E element) {
        boolean reuse;
        if (this.size < this.pool.length && !(reuse = this.reset(element))) {
            return;
        }
        if (this.lock == null) {
            this.pool[this.size++] = element;
        } else {
            Object object = this.lock;
            synchronized (object) {
                if (this.size < this.pool.length) {
                    this.pool[this.size++] = element;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.lock == null) {
            this.clearInternal();
        } else {
            Object object = this.lock;
            synchronized (object) {
                this.clearInternal();
            }
        }
    }

    private void clearInternal() {
        while (this.size > 0) {
            --this.size;
            this.pool[this.size] = null;
        }
    }
}

