/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.process.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.concurrent.api.Stoppable;
import net.sf.mmm.util.concurrent.base.SimpleExecutor;
import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;
import net.sf.mmm.util.io.api.AsyncTransferrer;
import net.sf.mmm.util.io.api.StreamUtil;
import net.sf.mmm.util.io.base.StreamUtilImpl;
import net.sf.mmm.util.process.api.AsyncProcessExecutor;
import net.sf.mmm.util.process.api.ProcessContext;
import net.sf.mmm.util.process.api.ProcessUtil;

public class ProcessUtilImpl
extends AbstractLoggableComponent
implements ProcessUtil {
    private static ProcessUtil instance;
    private StreamUtil streamUtil;
    private Executor executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProcessUtil getInstance() {
        if (instance != null) return instance;
        Class<ProcessUtilImpl> clazz = ProcessUtilImpl.class;
        synchronized (ProcessUtilImpl.class) {
            if (instance != null) return instance;
            ProcessUtilImpl util = new ProcessUtilImpl();
            util.initialize();
            instance = util;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.executor == null) {
            this.executor = SimpleExecutor.INSTANCE;
        }
        if (this.streamUtil == null) {
            this.streamUtil = StreamUtilImpl.getInstance();
        }
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    @Inject
    public void setExecutor(Executor executor) {
        this.getInitializationState().requireNotInitilized();
        this.executor = executor;
    }

    protected StreamUtil getStreamUtil() {
        return this.streamUtil;
    }

    @Inject
    public void setStreamUtil(StreamUtil streamUtil) {
        this.streamUtil = streamUtil;
    }

    @Override
    public int execute(ProcessContext context, ProcessBuilder ... builders) throws IOException, InterruptedException {
        ProcessExecutor processExecutor = new ProcessExecutor(context, builders);
        return processExecutor.call();
    }

    @Override
    public int execute(ProcessContext context, long timeout, TimeUnit unit, ProcessBuilder ... builders) throws IOException, TimeoutException, InterruptedException {
        AsyncProcessExecutor processExecutor = this.executeAsync(context, builders);
        try {
            int n = processExecutor.get(timeout, unit);
            return n;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            throw new IllegalStateException(e);
        }
        finally {
            processExecutor.cancel(true);
        }
    }

    @Override
    public AsyncProcessExecutor executeAsync(ProcessContext context, ProcessBuilder ... builders) throws IOException {
        ProcessExecutor processExecutor = new ProcessExecutor(context, builders);
        AsyncProcessExecutorImpl asyncExecutor = new AsyncProcessExecutorImpl(processExecutor);
        this.getExecutor().execute(asyncExecutor);
        return asyncExecutor;
    }

    protected class ProcessExecutor
    implements Callable<Integer>,
    Stoppable {
        private final ProcessContext context;
        private final Process[] processes;
        private final AsyncTransferrer[] transferrers;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProcessExecutor(ProcessContext context, ProcessBuilder[] builders) throws IOException {
            StreamUtil streamUtility = ProcessUtilImpl.this.getStreamUtil();
            if (builders.length == 0) {
                streamUtility.close(context.getInStream());
                streamUtility.close(context.getOutStream());
                streamUtility.close(context.getErrStream());
                throw new NlsIllegalArgumentException((Object)"builders must NOT be empty!");
            }
            this.context = context;
            this.processes = new Process[builders.length];
            this.transferrers = new AsyncTransferrer[builders.length + builders.length + 1];
            boolean success = false;
            try {
                InputStream in = context.getInStream();
                OutputStream err = context.getErrStream();
                for (int i = 0; i < builders.length; ++i) {
                    Process process = builders[i].start();
                    AsyncTransferrer inOutTransferrer = streamUtility.transferAsync(in, process.getOutputStream(), false);
                    AsyncTransferrer errTransferrer = streamUtility.transferAsync(process.getErrorStream(), err, true);
                    this.processes[i] = process;
                    in = this.processes[i].getInputStream();
                    int transferrersIndex = i + i;
                    this.transferrers[transferrersIndex] = inOutTransferrer;
                    this.transferrers[transferrersIndex + 1] = errTransferrer;
                }
                this.transferrers[builders.length + builders.length] = streamUtility.transferAsync(in, context.getOutStream(), false);
                success = true;
            }
            finally {
                if (!success) {
                    this.stop();
                }
            }
        }

        protected void dispose() {
            int i;
            for (i = 0; i < this.processes.length; ++i) {
                if (this.processes[i] == null) continue;
                try {
                    this.processes[i].destroy();
                }
                catch (RuntimeException e) {
                    ProcessUtilImpl.this.getLogger().warn(e.getLocalizedMessage(), (Throwable)e);
                }
                this.processes[i] = null;
            }
            for (i = 0; i < this.transferrers.length; ++i) {
                if (this.transferrers[i] == null) continue;
                try {
                    this.transferrers[i].cancel(true);
                }
                catch (RuntimeException e) {
                    ProcessUtilImpl.this.getLogger().warn(e.getLocalizedMessage(), (Throwable)e);
                }
                this.transferrers[i] = null;
            }
            StreamUtil streamUtility = ProcessUtilImpl.this.getStreamUtil();
            streamUtility.close(this.context.getInStream());
            streamUtility.close(this.context.getOutStream());
            streamUtility.close(this.context.getErrStream());
        }

        public void stop() {
            this.dispose();
        }

        @Override
        public Integer call() throws InterruptedException {
            try {
                int returnCode = 0;
                for (int i = 0; i < this.processes.length; ++i) {
                    returnCode = this.processes[i].waitFor();
                }
                Integer n = returnCode;
                return n;
            }
            finally {
                this.dispose();
            }
        }
    }

    protected static class AsyncProcessExecutorImpl
    extends FutureTask<Integer>
    implements AsyncProcessExecutor {
        private final ProcessExecutor executor;

        public AsyncProcessExecutorImpl(ProcessExecutor executor) {
            super(executor);
            this.executor = executor;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.executor.stop();
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

