/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.resource.base;

import java.util.HashMap;
import java.util.Map;
import net.sf.mmm.util.exception.api.DuplicateObjectException;
import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.resource.api.BrowsableResource;
import net.sf.mmm.util.resource.api.BrowsableResourceFactory;
import net.sf.mmm.util.resource.api.DataResource;
import net.sf.mmm.util.resource.api.ResourceUri;
import net.sf.mmm.util.resource.api.ResourceUriUndefinedException;
import net.sf.mmm.util.resource.api.spi.DataResourceProvider;
import net.sf.mmm.util.resource.base.AbstractBrowsableResourceProxy;
import net.sf.mmm.util.resource.base.AbstractDataResourceFactory;
import net.sf.mmm.util.resource.base.ResourceUriImpl;

public abstract class AbstractBrowsableResourceFactory
extends AbstractDataResourceFactory
implements BrowsableResourceFactory {
    private final Map<String, DataResourceProvider<? extends DataResource>> schema2providerMap = new HashMap<String, DataResourceProvider<? extends DataResource>>();

    public void registerProvider(DataResourceProvider<? extends DataResource> provider) throws DuplicateObjectException {
        this.getInitializationState().requireNotInitilized();
        if (provider == null) {
            throw new NlsNullPointerException("provider");
        }
        String[] schemaPrefixes = provider.getSchemePrefixes();
        if (schemaPrefixes == null) {
            throw new NlsNullPointerException(provider.getClass().getName() + ".getSchemaPrefix()");
        }
        if (schemaPrefixes.length == 0) {
            throw new NlsIllegalArgumentException((Object)(provider.getClass().getName() + ".getSchemaPrefix()"));
        }
        if (provider.getResourceType() == null) {
            throw new NlsNullPointerException(provider.getClass().getName() + ".getResourceType()");
        }
        for (String schemaPrefix : schemaPrefixes) {
            if (this.schema2providerMap.containsKey(schemaPrefix)) {
                throw new DuplicateObjectException(provider, (Object)schemaPrefix);
            }
            this.schema2providerMap.put(schemaPrefix, provider);
        }
    }

    public void registerProvider(DataResourceProvider<? extends DataResource> provider, String schemaPrefix) throws DuplicateObjectException {
        this.getInitializationState().requireNotInitilized();
        if (provider == null) {
            throw new NlsNullPointerException("provider");
        }
        if (provider.getResourceType() == null) {
            throw new NlsNullPointerException(provider.getClass().getName() + ".getResourceType()");
        }
        if (this.schema2providerMap.containsKey(schemaPrefix)) {
            throw new DuplicateObjectException(provider, (Object)schemaPrefix);
        }
        this.schema2providerMap.put(schemaPrefix, provider);
    }

    protected DataResourceProvider<? extends DataResource> getProvider(ResourceUri resourceUri) throws ResourceUriUndefinedException {
        DataResourceProvider<? extends DataResource> provider;
        String schemePrefix = resourceUri.getSchemePrefix();
        if (schemePrefix == null) {
            schemePrefix = "file://";
        }
        if ((provider = this.schema2providerMap.get(schemePrefix)) == null) {
            throw new ResourceUriUndefinedException(resourceUri.getUri());
        }
        return provider;
    }

    @Override
    protected DataResource createDataResource(ResourceUri resourceUri) throws ResourceUriUndefinedException {
        return this.getProvider(resourceUri).createResource(resourceUri);
    }

    protected BrowsableResource createBrowsableResource(ResourceUri resourceUri) throws ResourceUriUndefinedException {
        DataResourceProvider<? extends DataResource> provider = this.getProvider(resourceUri);
        if (!BrowsableResource.class.isAssignableFrom(provider.getResourceType())) {
            NlsIllegalArgumentException cause = new NlsIllegalArgumentException(provider.getResourceType());
            throw new ResourceUriUndefinedException((Throwable)cause, resourceUri.getUri());
        }
        return (BrowsableResource)provider.createResource(resourceUri);
    }

    @Override
    public BrowsableResource createBrowsableResource(String resourceUri) throws ResourceUriUndefinedException {
        ResourceUriImpl uri = new ResourceUriImpl(resourceUri);
        BrowsableResource resource = this.createBrowsableResource(uri);
        return new BrowsableResourceAdapter(resource);
    }

    protected class BrowsableResourceAdapter
    extends AbstractBrowsableResourceProxy {
        private final BrowsableResource delegate;

        public BrowsableResourceAdapter(BrowsableResource delegate) {
            this.delegate = delegate;
        }

        @Override
        protected BrowsableResource getDelegate() {
            return this.delegate;
        }

        @Override
        public DataResource navigate(String relativePath) throws ResourceUriUndefinedException {
            ResourceUriImpl resourceUri = new ResourceUriImpl(relativePath);
            Object result = resourceUri.getSchemePrefix() == null ? super.navigate(relativePath) : AbstractBrowsableResourceFactory.this.createBrowsableResource(resourceUri);
            if (result instanceof BrowsableResource) {
                return new BrowsableResourceAdapter((BrowsableResource)result);
            }
            return new AbstractDataResourceFactory.DataResourceAdapter(AbstractBrowsableResourceFactory.this, (DataResource)result);
        }

        @Override
        public BrowsableResource cd(String path) {
            ResourceUriImpl resourceUri = new ResourceUriImpl(path);
            BrowsableResource target = resourceUri.getSchemePrefix() == null ? super.cd(path) : AbstractBrowsableResourceFactory.this.createBrowsableResource(resourceUri);
            return new BrowsableResourceAdapter(target);
        }
    }
}

