/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.resource.base;

import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.resource.api.DataResource;
import net.sf.mmm.util.resource.api.DataResourceFactory;
import net.sf.mmm.util.resource.api.ResourceUri;
import net.sf.mmm.util.resource.api.ResourceUriUndefinedException;
import net.sf.mmm.util.resource.base.AbstractDataResourceProxy;
import net.sf.mmm.util.resource.base.ResourceUriImpl;

public abstract class AbstractDataResourceFactory
extends AbstractLoggableComponent
implements DataResourceFactory {
    @Override
    public DataResource createDataResource(String resourceUri) throws ResourceUriUndefinedException {
        ResourceUriImpl uri = new ResourceUriImpl(resourceUri);
        DataResource resource = this.createDataResource(uri);
        return new DataResourceAdapter(resource);
    }

    protected abstract DataResource createDataResource(ResourceUri var1) throws ResourceUriUndefinedException;

    protected class DataResourceAdapter
    extends AbstractDataResourceProxy {
        private final DataResource delegate;

        public DataResourceAdapter(DataResource delegate) {
            this.delegate = delegate;
        }

        @Override
        protected DataResource getDelegate() {
            return this.delegate;
        }

        @Override
        public DataResource navigate(String relativePath) throws ResourceUriUndefinedException {
            ResourceUriImpl resourceUri = new ResourceUriImpl(relativePath);
            DataResource result = resourceUri.getSchemePrefix() == null ? super.navigate(relativePath) : AbstractDataResourceFactory.this.createDataResource(resourceUri);
            return new DataResourceAdapter(result);
        }
    }
}

