/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.resource.base;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.resource.api.ResourceUri;

public class ResourceUriImpl
implements ResourceUri {
    private static final Pattern SCHEME_PATTERN = Pattern.compile("([a-zA-Z][a-zA-Z0-9\\.\\-+]+:(//)?)(.*)");
    private final String uri;
    private final String schemePrefix;
    private final String path;

    public ResourceUriImpl(String uri) {
        if (uri == null) {
            throw new NlsNullPointerException("uri");
        }
        this.uri = uri;
        Matcher matcher = SCHEME_PATTERN.matcher(uri);
        if (matcher.matches()) {
            this.schemePrefix = matcher.group(1).toLowerCase(Locale.US);
            this.path = matcher.group(3);
        } else {
            this.schemePrefix = null;
            this.path = uri;
        }
    }

    public ResourceUriImpl(String schemePrefix, String path) {
        this.path = path;
        if (schemePrefix == null) {
            this.schemePrefix = null;
            this.uri = this.path;
        } else {
            this.schemePrefix = schemePrefix.toLowerCase(Locale.US);
            this.uri = this.schemePrefix + this.path;
        }
    }

    public String getUri() {
        return this.uri;
    }

    public String getSchemePrefix() {
        return this.schemePrefix;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.uri;
    }
}

