/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.resource.impl.spi;

import javax.inject.Inject;
import net.sf.mmm.util.file.api.FileUtil;
import net.sf.mmm.util.file.base.FileUtilImpl;
import net.sf.mmm.util.resource.api.ResourceUri;
import net.sf.mmm.util.resource.base.FileResource;
import net.sf.mmm.util.resource.base.spi.AbstractDataResourceProvider;

public class FileResourceProvider
extends AbstractDataResourceProvider<FileResource> {
    private FileUtil fileUtil;

    protected void doInitialize() {
        super.doInitialize();
        if (this.fileUtil == null) {
            this.fileUtil = FileUtilImpl.getInstance();
        }
    }

    @Inject
    public void setFileUtil(FileUtil fileUtil) {
        this.getInitializationState().requireNotInitilized();
        this.fileUtil = fileUtil;
    }

    @Override
    public String[] getSchemePrefixes() {
        return new String[]{"file://"};
    }

    @Override
    public Class<FileResource> getResourceType() {
        return FileResource.class;
    }

    @Override
    public FileResource createResource(ResourceUri resourceUri) {
        String path = this.fileUtil.normalizePath(resourceUri.getPath());
        return new FileResource(path);
    }
}

