/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.text.api;

import java.util.Locale;
import net.sf.mmm.util.lang.api.HorizontalAlignment;

public class TextColumnInfo {
    public static final int MINIMUM_WIDTH_FOR_INDENT_AND_HYPHEN = 4;
    public static final int WIDTH_AUTO_ADJUST = -1;
    private int width = -1;
    private String borderLeft = "";
    private String borderRight = "";
    private char filler;
    private String indent = "";
    private HorizontalAlignment alignment = HorizontalAlignment.LEFT;
    private char[] wrapChars;
    private char[] omitChars;
    private IndentationMode indentationMode;
    private Locale locale;

    public TextColumnInfo() {
        this.filler = (char)32;
        this.wrapChars = new char[]{' ', '-', '\t'};
        this.omitChars = new char[]{' '};
        this.indentationMode = IndentationMode.NO_INDENT_AFTER_DOUBLE_NEWLINE;
        this.locale = Locale.getDefault();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getBorderWidth() {
        return this.borderLeft.length() + this.borderRight.length();
    }

    public String getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(String separator) {
        this.borderRight = separator;
    }

    public String getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(String separator) {
        this.borderLeft = separator;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(HorizontalAlignment alignment) {
        this.alignment = alignment;
    }

    public char getFiller() {
        return this.filler;
    }

    public void setFiller(char filler) {
        this.filler = filler;
    }

    public char[] getWrapChars() {
        return this.wrapChars;
    }

    public void setWrapChars(char ... wrapChars) {
        this.wrapChars = wrapChars;
    }

    public char[] getOmitChars() {
        return this.omitChars;
    }

    public void setOmitChars(char ... omitChars) {
        this.omitChars = omitChars;
    }

    public IndentationMode getIndentationMode() {
        return this.indentationMode;
    }

    public void setIndentationMode(IndentationMode indentationMode) {
        this.indentationMode = indentationMode;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public static enum IndentationMode {
        NO_INDENT_AFTER_NEWLINE,
        NO_INDENT_AFTER_DOUBLE_NEWLINE,
        INDENT_AFTER_NEWLINE;

    }
}

