/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.text.base;

import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.nls.api.NlsResourceLocator;
import net.sf.mmm.util.nls.base.DefaultNlsResourceLocator;
import net.sf.mmm.util.text.api.Hyphenator;
import net.sf.mmm.util.text.api.HyphenatorBuilder;

public abstract class AbstractHyphenatorBuilder
extends AbstractLoggableComponent
implements HyphenatorBuilder {
    private final ConcurrentHashMap<String, WeakReference<Hyphenator>> hyphenatorCache = new ConcurrentHashMap();
    private NlsResourceLocator resourceLocator;

    protected void doInitialize() {
        super.doInitialize();
        if (this.resourceLocator == null) {
            DefaultNlsResourceLocator impl = new DefaultNlsResourceLocator();
            impl.initialize();
            this.resourceLocator = impl;
        }
    }

    @Override
    public Hyphenator getHyphenator() {
        return this.getHyphenator(Locale.getDefault());
    }

    @Override
    public Hyphenator getHyphenator(Locale locale) {
        Hyphenator hyphenator = null;
        String[] localeInfixes = this.resourceLocator.getLocaleInfixes(locale);
        for (int i = 0; i < localeInfixes.length; ++i) {
            WeakReference<Hyphenator> reference = this.hyphenatorCache.get(localeInfixes[i]);
            if (reference != null) {
                hyphenator = (Hyphenator)reference.get();
            }
            if (hyphenator == null && (hyphenator = this.createHyphenator(localeInfixes[i])) != null) {
                reference = new WeakReference<Hyphenator>(hyphenator);
                for (int j = i; j >= 0; --j) {
                    this.hyphenatorCache.put(localeInfixes[j], reference);
                }
            }
            if (hyphenator != null) break;
        }
        return hyphenator;
    }

    protected abstract Hyphenator createHyphenator(String var1);

    protected NlsResourceLocator getResourceLocator() {
        return this.resourceLocator;
    }

    @Inject
    public void setResourceLocator(NlsResourceLocator resourceLocator) {
        this.getInitializationState().requireNotInitilized();
        this.resourceLocator = resourceLocator;
    }
}

