/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.text.base;

import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;
import net.sf.mmm.util.text.api.StringHasher;
import net.sf.mmm.util.text.base.HyphenationPatternPosition;

public class HyphenationPattern {
    private final String wordPart;
    private final int wordPartHash;
    private final HyphenationPatternPosition[] hyphenationPositions;
    public static final char TERMINATOR = '.';

    public HyphenationPattern(String pattern, StringHasher hasher) {
        int length = pattern.length();
        if (length <= 2) {
            throw new NlsIllegalArgumentException((Object)pattern, "pattern");
        }
        int hpLength = 0;
        for (int i = 0; i < length; ++i) {
            char c = pattern.charAt(i);
            if (c < '0' || c > '9') continue;
            ++hpLength;
        }
        this.hyphenationPositions = new HyphenationPatternPosition[hpLength];
        int hpIndex = 0;
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = pattern.charAt(i);
            if (c >= '0' && c <= '9') {
                this.hyphenationPositions[hpIndex++] = new HyphenationPatternPosition(sb.length(), c - 48);
                continue;
            }
            sb.append(c);
        }
        this.wordPart = sb.toString();
        this.wordPartHash = hasher.getHashCode((CharSequence)this.wordPart);
    }

    protected HyphenationPatternPosition[] getHyphenationPositions() {
        return this.hyphenationPositions;
    }

    public String getWordPart() {
        return this.wordPart;
    }

    public int getWordPartHash() {
        return this.wordPartHash;
    }

    public String getPattern() {
        StringBuilder pattern = new StringBuilder(this.wordPart.length() + this.hyphenationPositions.length);
        int start = 0;
        for (HyphenationPatternPosition position : this.hyphenationPositions) {
            int end = position.index;
            pattern.append(this.wordPart, start, end);
            pattern.append(Integer.toString(position.ranking));
            start = end;
        }
        pattern.append(this.wordPart, start, this.wordPart.length());
        return pattern.toString();
    }

    public String toString() {
        return this.getPattern();
    }
}

